var path = require('path');

module.exports = function(grunt) {
	// Project configuration.
	grunt.initConfig({
		jshint: {
			all: [
				'Gruntfile.js',
				'sites/**/*.js',
				'scripts/*.js',
				'scripts/controllers/*.js',
				'scripts/rmv/*.js',
				'scripts/services/*.js',
				'scripts/controllers/*.js',
				'scripts/views/*.js'
			],
			options: {
				jshintrc: '.jshintrc'
			}
		},

		/**********************
		//
        // DISABLE PUBLISH FOR THIS REPO TO PREVENT LEAKING ASSETS
        // DO NOT UNCOMMENT UNDER ANY CIRCUMSTANCES
        //
        /**********************/
        
		publish: [
			{
				type: 'pointroll',
				test: 'test',
				year: 2014,
				name: 'Mighty Zeus Midpage',

				notify: [
					// mal
					'ryang@mediaartslab.com',
					'paulo@mediaartslab.com',

					// pointroll
					'ptr-applelaunchsupportlist@pointroll.com',

					// haus
					'andy@madeinhaus.com'
				],

				server: {
					host: 'ftp.pointroll.com',
					username: 'ftpMarcom',
					password: 'n9aDP7Kf'
				}
			}
		],
		

		siteboss: {
			type: 'marcom',
			host: '127.0.0.1',
			port: 1337,
			iframe: false,
			scripts: [
				'scripts/rmv/Mediamind.js'
			],
			replacements: {

			}
		},

		// Configuration to be run (and then tested).
		marcom: {
			imagePath: 'images/',
			videoPath: 'videos/',

			scripts: [{
				name: 'build',
				files: [
					// library
					'scripts/MALLibrary/ecma5.js',
					'scripts/MALLibrary/MAL.js',
					'scripts/MALLibrary/Util.js',
					'scripts/MALLibrary/Object.js',
					'scripts/MALLibrary/Set.js',
					'scripts/MALLibrary/Environment.js',
					'scripts/MALLibrary/Preloader.js',
					'scripts/MALLibrary/RMVProxy.js',
					'scripts/MALLibrary/Style.js',
					'scripts/MALLibrary/Stylesheet.js',
					'scripts/MALLibrary/ViewStyle.js',
					'scripts/MALLibrary/View.js',
					'scripts/MALLibrary/ViewController.js',
					'scripts/MALLibrary/TimeoutManager.js',
					'scripts/MALLibrary/ScriptLoader.js',
					'scripts/MALLibrary/RawTween.js',
					'scripts/MALLibrary/KeyframeAnimation.js',
					'scripts/MALLibrary/video/Base.js',
					'scripts/MALLibrary/video/Advanced.js',
					'scripts/MALLibrary/tween/Stage.js',
					'scripts/MALLibrary/tween/Layer.js',
					'scripts/MALLibrary/tween/LayerProxy.js',
					'scripts/MALLibrary/tween/CSSLayer.js',
					'scripts/MALLibrary/tween/CSSJSLayer.js',
					'scripts/MALLibrary/tween/JSLayer.js',

					// project
					'scripts/services/ImageLoader.js',
					'scripts/services/MarcomProxy.js',
					'scripts/services/InView.js',
					'scripts/services/MouseHotspot.js',
					'scripts/services/FrequencyCap.js',
					'scripts/services/Keyline.js',
					'scripts/services/Supertag.js',
					'scripts/services/ScrollRange.js',
					'scripts/views/Main.js',
					'scripts/views/RichMedia/Main.js',
					'scripts/controllers/Main.js',
					'scripts/controllers/RichMedia/Main.js',
					'scripts/bootstrap.js',
					'drivers/Default.js'


				]
			}],

			vendors: [
				{
					type: 'pointroll',
					scaffolding: 'flat',
					compression: false,
					rmv: 'scripts/rmv/Pointroll.js',
					geos: {
						us: {
							'pitchfork.com': 1300,
							'theverge.com': 1300,
							'wired.com': 1300
						}
					}
				}, {
					type: 'mediamind',
					scaffolding: 'per_site',
					compression: true,
					rmv: 'scripts/rmv/Mediamind.js',
					geos: {
						uk: {
							'pitchfork.com': 1300,
							'theverge.com': 1300
						}
					}
				}, {
					type: 'staging_WIP',
					scaffolding: 'flat',
					compression: false,
					rmv: 'scripts/rmv/Blank.js',
					tags: ['localstorage'],
					geos: {
						us: {
							'mightyzeus.example.com': 1300
						}
					}
				}
			]
		}

	});

	// These plugins provide necessary tasks.
	grunt.loadNpmTasks('grunt-marcom');
	grunt.loadNpmTasks('grunt-siteboss');
	grunt.loadNpmTasks('grunt-contrib-jshint');
	grunt.loadTasks('tasks');

	grunt.registerTask('default', ['jshint', 'livereload-start', 'connect', 'regarde']);
	grunt.registerTask('build', ['marcom-build']);
	grunt.registerTask('publish', ['build', 'marcom-publish']);
	grunt.registerTask('endcard', ['marcom-endcard']);

};