# grunt-marcom

uniform tools that we can use inside of our itunes projects

# tasks

* `marcom-build` builds project
* `marcom-stage` will stage build to specified server

## file info

a general marcom project requires the following in its `Gruntfile.js`

```javascript
    // path to our image folder
    imagePath: 'images/',

    scripts: [
        // all of the files we want to end up in our build.js
        {
            name: 'build',
            files: [
                // library
                'scripts/MALLibrary/ecma5.js',
                'scripts/MALLibrary/MAL.js',
                'scripts/MALLibrary/Util.js',
                'scripts/MALLibrary/Object.js',
                ...
                ...

                // project
                'scripts/services/ImageLoader.js',
                'scripts/services/MarcomProxy.js',
                ...
                ...
                'scripts/main.js'
            ]
        }
    ]
```

###Staging Configuration

####Required:
- **host**: ip address or domain of server
- **protocol**: ftp or sftp
- **root**: filepath to store all revisions

    #####Register the task:
    ```javascript
    grunt.registerTask('stage', ['jshint', 'marcom-build', 'marcom-stage']);
    ```
    
####Optional:
- **directory**: additional directory you would like to specify.


```javascript
    stage: {
        host: '23.253.204.118',
        protocol: 'ftp',
        root: 'html/paul_king',
        directory: 'whatever_folder_you_wanna_call_this'
    },
```




## vendor and site info

specify the vendors you will be delivering to and the format they require

```javascript
    vendors: [
        {
            scaffolding: 'flat',
            type: 'pointroll',
            compression: true,
            rmv: 'scripts/MALRMVPointroll.js',
            geos: {
                us: {
                    'idolator.com': 900,
                    'nymag.com': 900,
                    'pitchfork.com': 900
                },
                ca: {
                    'music.cbc.ca': 900,
                    'www.mtv.ca': 900
                }
            }
        }
    ]
```

vendor properties

* `scaffolding` currently only supports `flat`, and `per_site`
* `type` name of vendor
* `compression` can be set to *false*, *true*, or {packer: false}
* `rmv` location of the vendors rmv file
* `geos` contains all the sites