A small promise based tool to use either SFTP or FTP in your node projects.

```
Transmit = require('node-transmit');

var connection = new Transmit({         
    protocol: "SFTP",
    host: 'digital.mediaartslab.com',           
    rootPath: path.join("path/to/somewhere"),
    createRootPath: true,
    ready: function () {
       
    }
}); 
```

##Setup Options
- protocol: SFTP / FTP
- host: The place you are trying to reach
- rootPath: perform a cd into your root path
- createRootPath: it can create the root path for you if its not there
- ready: a callback when you are ready to start doing stuff

###Commands
#####connection.cdOrCreate
Travel to a folder or create it when its not there

Options:
- path, the path you would like to travel to

```
connection.cdOrCreate("somewhere/else").done(function() {

    });
```

#####connection.cd
Travel to a folder

Options:
- path, the path you would like to travel to. This will give an error if the folder doesn't exist

```
connection.cd("somewhere/else").done(function() {

    });
```

#####connection.ls
Get the contents of a folder

```
connection.cdOrCreate("somewhere/else").done(function() {

    });
```

#####connection.mkdirs
Create multiple folders at the same time

options:
- path
- recursive, bool if you would like to use recursive creation

```
connection.mkdirs(["somewhere","else","next","to"],true).done(function() {

    });
```

#####connection.mkdir
Create a folder, this can be done recursively

options:
- path
- recursive, bool if you would like to use recursive creation

```
connection.mkdirs("somewhere/else/to",true).done(function() {

    });
```


#####connection.rmdir
Remove a folder, this can be done recursively

options:
- path
- recursive, bool if you would like everything in the folder to be cleared out

```
connection.rmdir("somewhere/else/to",true).done(function() {

    });
```


#####connection.rmfile
Remove a file

options:
- path

```
connection.rmfile("somewhere/else/to/yeah.jpg").done(function() {

    });
```


#####connection.upload
Upload a file

options:
- source
- destination

```
connection.upload("somewhere/else/to/yeah.jpg", "dest/path/to/upload.jpg").done(function() {

    });
```

#####connection.disconnect
kill the connection

