# siteboss

required folder structure

```javascript
sites
- {geo}
-- {domain}
--- index.html
--- site.js
--- style.css
--- ...
```

running site boss

    grunt siteboss
    grunt siteboss --port 1337
    grunt siteboss --host 0.0.0.0 --port 1337

go here for a list of sites

    http://0.0.0.0:1337

you access sites like this

    http://0.0.0.0:1337/{geo}/http://{domain}/
    http://0.0.0.0:1337/live/{geo}/http://{domain}/ (forces live preview of site)

you also can access a live build.js here (useful for charles)

    http://0.0.0.0:1337/build.js

    you can manually override MALChangeset by adding a hash #r64

#### auth

if you want to use basic auth you can do this

    grunt siteboss --auth user:password

#### site files

`index.html` if you place a **index.html** file in the domain folder that will be the HTML source that gets loaded (mainly used for freezing the site content so we don't have to worry about them updating their site)

`site.js` the placement and site config file

`{filename}.js` additional JS files (mainly used for testing)

`{filename}.css` additional CSS files (mainly used for testing)

## configuration (grunt.js)

#### core settings
```javascript
siteboss: {
    type: 'marcom', // project type
    host: '0.0.0.0',
    port: 1337,
    scripts: [
        'scripts/rmv/Blank.js' // include additional scripts
    ]
}
```

#### replacements

replacement function for replacing live content

```javascript
    replacements: {
        'www.rollingstone.com': function ($) {
            $('body').append('<div>hello world</div>');
        }
    }
```

#### publishing

```javascript
    publish: [
        {
            type: 'pointroll',

            notify: [
                'email@mediaartslab.com',
                ...
            ],

            server: {
                path: 'Apple Marcom 2013 Deployement Package Template Folder',
                host: 'ftp.pointroll.com',
                username: '...',
                password: '...'
            }
        }
    ]
```