var glob = require('glob'),
	when = require('whenplus'),
	fs = require('fs'),
	path = require('path'),
	express = require('express'),
	url = require('url'),
	cheerio = require('cheerio'),
	Requester = require('requester'),
	PromiseObject = require('promise-object');

function promisify (func, scope) {
	return function () {
		var deferred = when.defer(),
			args = Array.prototype.slice.call(arguments);

		args.push(function (error, results) {
			if (error) {
				deferred.reject(error);
			} else {
				deferred.resolve(results);
			}
		});

		func.apply(scope || null, args);

		return deferred.promise;
	};
}

var globbed = promisify(glob),
	read = promisify(fs.readFile, fs),
	requester = new Requester({debug: true});

var Siteboss = PromiseObject.create({
	initialize: function ($self, $config) {
		this._project = $config.project;
		this._siteboss = $config.siteboss;
		this._app = express();

		if ($config.auth) {
			this._app.use(function (request, response, next) {
				if (request.url.match(/\.(mp4|webm)$/)) {
					next();
				} else {
					express.basicAuth($config.auth.username, $config.auth.password)(request, response, next);
				}
			});
		}

		this._scripts = this._siteboss.scripts.slice(0);
		this._project.scripts.forEach(function (script) {
			$self._scripts = $self._scripts.concat(script.files);
		});

		this._handleSiteRoute();

		this._app.use('/scripts', express.static('scripts'));
		this._app.use('/images', express.static('images'));

		if (!this._siteboss.host) {
			console.log(' - looking up network ip address (no host provided)');
			require('dns').lookup(require('os').hostname(), function (error, address) {
				$self._siteboss.host = address;
				console.log(' - siteboss is running on ' + ($self._siteboss.host + ':' + $self._siteboss.port).green + '\n');
				$self._app.listen($self._siteboss.port, $self._siteboss.host);
			});
		} else {
			console.log(' - siteboss is running on ' + (this._siteboss.host + ':' + this._siteboss.port).green + '\n');
			this._app.listen(this._siteboss.port, this._siteboss.host);
		}
	},

	_handleSiteRoute: function ($self) {
		this._app.use(function(request, response, next) {
			var file = url.parse(request.url).pathname.slice(1);

			globbed('sites/**/*.+(webm|mp4|js|css)').done(function (files) {
				if (files.indexOf(file) !== -1) {
					response.sendfile(file);
				} else {
					// global video asset folder
					if (file.match(/\.(mp4|webm)$/)) {
						globbed('videos/*.+(webm|mp4)').done(function (files) {
							file = 'videos/' + path.basename(file);

							if (files.indexOf(file) !== -1) {
								response.sendfile(file);
							} else {
								next();
							}
						});
					} else {
						next();
					}
				}
			});
		});

		this._app.get('/', function(request, response) {
			globbed('sites/*/*/').done(function (sites) {
				var geos = {};

				sites.forEach(function (site) {


					var matches = site.match(/sites\/([a-z]{2,4})\/(.*)\//i),
						geo = matches[1],
						host = matches[2];

					geos[geo] = geos[geo] || [];
					geos[geo].push(host);

					
				});

				var html = '<style>body { font: helvetica, arial; color: #333} a {text-decoration: none; color: #c41200;} li {list-style: none;}</style>';

				for (var geo in geos) {
					html += '<h3>' + geo + '</h3>' +
							'<ul>';

					geos[geo].forEach(function (host) {
						html += '<li><a href="/' + geo + '/http://' + host + '">' + host + '</a></li>';
					});

					html += '</ul>';
				}

				response.send(html);
			});
		});

		this._app.get('/build.js', function(request, response) {
			var scripts = $self._scripts.filter(function (script) {
				return !script.match(/scripts\/rmv/);
			});

			when.map(scripts, read).done(function (sources) {
				var javascript = 'var MALChangeset = location.hash.slice(2);\n';

				sources.forEach(function (source, index) {
					javascript += '\n\n/* filename: ' + scripts[index] + ' */\n\n' + source;
				});

				response.setHeader('Content-Type', 'text/javascript');
				response.setHeader('Content-Length', javascript.length);
				response.end(javascript);
			});
		});

		this._app.get('/iframepage.html', function(request, response) {
			console.log('iframepage'.green);
		});

		this._app.get(/^(\/(live))?(?:\/([a-z]{2,4}))\/(.*)$/, function(request, response) {
			var live = !!request.params[1],
				geo = request.params[2],
				href = request.params[3],
				site = url.parse(href);

			var filepath = path.join('sites', geo, site.hostname);



			when.join(globbed(filepath + '/*.js'), globbed(filepath + '/*.css')).done(function (results) {
				$self._getIndex(filepath, href, live).done(function (source) {
					var scripts = results[0],
						styles = results[1],
						config = {
							host: $self._siteboss.host,
							port: $self._siteboss.port,
							paths: {
								images: '/images/',
								videos: '/' + filepath + '/'
							}
						};

					var boss =  "\n<!--\n              @         @\n" +
								"             @@  ..-..  @@                     ,,                ,,                                  \n" +
								"             @@@' _ _ '@@@                     db   mm          *MM                                  \n" +
								"              @(  . .  )@                           MM           MM                                  \n" +
								'               |  (_)  |             ,pP"Ybd `7MM mmMMmm .gP"Ya  MM,dMMb.   ,pW"Wq.  ,pP"Ybd ,pP"Ybd \n' +
								'               |   _   |             8I   `"   MM   MM  ,M\'   Yb MM    `Mb 6W\'   `Wb 8I   `" 8I   `" \n' +
								'               |_     _|             `YMMMa.   MM   MM  8M"""""" MM     M8 8M     M8 `YMMMa. `YMMMa. \n' +
								"              /|_'---'_|\\            L.   I8   MM   MM  YM.    , MM.   ,M9 YA.   ,A9 L.   I8 L.   I8 \n" +
								"             / | '\\_/' | \\           M9mmmP' .JMML. `Mbmo`Mbmmd' P^YbmdP'   `Ybmd9'  M9mmmP' M9mmmP' \n" +
								"            /  |  | |  |  \\         \n-->\n";

					var dev =   "\n<!--\n              .----.\n" +
								"              /___.--'-.\n" +
								"              C   '----'      \n" +
								"              |       )   .-----.\n" +
								"              |     -|   /_     /\n" +
								"              '''----'  /  )   /\n" +
								"              /       \\/'..'__/\n" +
								"             /        /   /\n" +
								"            /            /\n" +
								"                        /\\~~)__________\n" +
								"                          \\(___________)\n" +
								"                           | | | | | | |\n" +
								"                           | | |(__) | |\n-->\n";

					


					
					var $;

					if ($self._siteboss.iframe && !href.match('sitebossiframe')) {
						// iframe setting is on so lets create an iframe
						$ = cheerio.load(source);

						console.log(site.href);

						var iframe = '<iframe src="http://' + $self._siteboss.host + ':' + $self._siteboss.port + '/' + geo + '/' + site.href + 'sitebossiframe/?random=' + Math.random() + '" style="border:0px;" scrolling="no" width="'+ (request.query.width || 300) +'" height="'+ (request.query.height || 250) +'"></iframe>';

						var body = '<div id="mal-ad-container"></div>\n';

						
						if (!$('#mal-ad-container').length && $self._siteboss.autoContainer ) {
							$('body').append(body);
						}
						

						$('#mal-ad-container').append(iframe);

						response.setHeader('X-UA-Compatible', 'IE=Edge');
						response.send($.html());
						return;
					} else if ($self._siteboss.iframe && href.match('sitebossiframe')) {
						source = '<html><head></head><body></body></html>';
					}

					// update src locations
					source = source.replace(/(href|src)=(["'])\/(?!\/)([^"']+)(["'])/g, '$1=$2' + href + '/$3$4');

					$ = cheerio.load(source);

					$('head').prepend('<base href="' + href + '" target="_blank" />\n');

					var head = '\n\n<!-- config -->\n<script type="text/javascript">' +
									'var SITEBOSS = ' + JSON.stringify(config) + ';' +
									'var base = \'http://\' + window.SITEBOSS.host + \':\' + window.SITEBOSS.port,' +
									'MALPaths = {' +
										'images: base + SITEBOSS.paths.images,' +
										'videos: base + SITEBOSS.paths.videos,' +
										'scripts: base + SITEBOSS.paths.scripts' +
									'};' +
								'</script>\n';

					head += '\n<!-- library base scripts -->\n' + $self._scripts.map(function (file) {
						return '<script type="text/javascript" src="http://' + $self._siteboss.host + ':' + $self._siteboss.port + '/' + file + '?random=' + Math.random() + '"></script>';
					}).join('\n') + '\n';

					head += '\n<!-- site scripts -->\n' + scripts.map(function (file) {
						return '<script type="text/javascript" src="http://' + $self._siteboss.host + ':' + $self._siteboss.port + '/' + file + '?random=' + Math.random() + '"></script>';
					}).join('\n') + '\n';

					head += '\n<!-- site styles -->\n' + styles.map(function (file) {
						return '<link type="text/css" rel="stylesheet" media="all" href="http://' + $self._siteboss.host + ':' + $self._siteboss.port + '/' + file + '?random=' + Math.random() + '">';
					}).join('\n') + '\n';

					var body = '<div id="mal-ad-container"></div>\n';

					if ($self._siteboss.replacements[site.hostname]) {
						$self._siteboss.replacements[site.hostname]($);
					}

					$('head').append(boss + head + dev);

					if (!$('#mal-ad-container').length && ($self._siteboss.autoContainer || $self._siteboss.iframe)) {
						$('body').append(body);
					}

					response.setHeader('X-UA-Compatible', 'IE=Edge');
					response.send($.html());

					
				}, function (error) {console.log(error.stack);});
			});
		});
	},

	_getIndex: function ($deferred, $self, filepath, href, live) {
		fs.readFile(filepath + '/index.html', {encoding: 'utf8'}, function (error, source) {
			if (error || live) {
				requester.get(href, $deferred.resolve);
			} else {
				$deferred.resolve(String(source));
			}
		});
	}
});

module.exports = function(grunt) {
	grunt.registerTask('siteboss', '', function() {
		var callback = this.async(),
			siteboss = grunt.config('siteboss'),
			project = grunt.config(siteboss.type);

		var auth = grunt.cli.options.auth ? {username: grunt.cli.options.auth.split(':')[0], password: grunt.cli.options.auth.split(':')[1]} : null;

		siteboss.host = grunt.cli.options.host || siteboss.host;
		siteboss.port = grunt.cli.options.port || siteboss.port;

		new Siteboss({project: project, siteboss: siteboss, auth: auth});
	});
};