/*global MALPaths,MAL,MALChangeset,prActivity,pr_trk,prup,alert*/
var MALRMVBlank = function() {

	var clickURLS = {
		us: '',
		cafr: 'ca/fr/',
		caen: 'ca/'
	};

	MAL.define('rmv', new MAL.services.MarcomProxy({

		videoPercentage: 0,
		cached: false,
		staticReason: false,
		clickedForSound: false,

		paths: {
			images: window.MALPaths ? MALPaths.images : './images_fpo/',
			videos: window.MALPaths ? MALPaths.videos : './videos_fpo/',
			scripts: window.MALPaths ? MALPaths.scripts : './'
		},


		deviceIDPool: {
			'small': 100, // Reserves 100-199
			'medium': 200, // Reserves 200-299
			'large': 300, // Reserves 300-399
			'mobile': 400, // Reserves 400-499
			'tablet': 500 // Reserves 500-599
		},

		eventIDs: {
			//Not User Initiated
			'init': 101001,
			'capped': 101002,
			'videoloadingbar': 101003,
			'videoautoplay': 101004,
			'videoloadingplay': 101005,
			'videoended': 101006,
			'static': 101007,
			'richmedia': 101008,
			'didnotshow': 101009,
			'autopreload': 101010,
			//User Initiated
			'collapse': 0,
			'hide': 1,
			'resize': 2,
			'clickthrough': 3,
			'optin': 4,
			'replay': 5,
			'clickforsound': 6,
			'close': 7
		},

		setDeviceSize: function(size) {
			MAL.Util.log("RMV: Set Device Size: " + size);

			if (MAL.isUndefined(this.deviceIDPool[size])) {
				MAL.Util.log("RMV: Set device size [" + size + "] does not exist in pool");
			} else {
				this.creativeSize = size;
			}
		},

		getPrID: function(eventName) {
			if (MAL.isUndefined(this.eventIDs[eventName])) {
				MAL.Util.log("RMV: Event [" + eventName + "] does not exist");
			}
			if (MAL.isUndefined(this.creativeSize)) {
				return this.eventIDs[eventName];
			}
			return this.deviceIDPool[this.creativeSize] + this.eventIDs[eventName];
		},

		isRMVReady: function() {
			return true;
		},

		filePathProxy: function(filepath, filename) {
			// every file request goes through this method, this is where you would add additional filepath logic
			return filepath + filename;
		},

		bwNames: [
			[0, '0-0.5m'],
			[512, '0.5-1m'],
			[1000, '1-2m'],
			[2000, '2-3m'],
			[3000, '3-4m'],
			[4000, '4-5m'],
			[5000, '5-6m'],
			[6000, '6-7m'],
			[7000, '7-8m'],
			[8000, '8-9m'],
			[9000, '9-10m'],
			[10000, '10m']
		],

		baseUrl: {
			Red: [
				[0, 'http://www.apple.com/']
			],
			Blue: [
				[0, 'http://www.apple.com/']
			]

		},

		getBaseUrl: function() {
			var self = this;

			return this.baseUrl[window.MALCreative].reduce(function(p, c) {
				return (self.bandwidth >= c[0]) ? c[1] : p;
			}, this.baseUrl[window.MALCreative][0][1]);

		},

		events: {

			onDeviceSize: {
				handler: function(size) {
					MAL.Util.log("RMV: Set Device Size: " + size);
					this.setDeviceSize(size);
				}
			},

			onInit: {
				unique: true,
				handler: function(o) {
					this.creativeVersion = o.video;
					console.log(this);
					MAL.Util.log('RMV: Init: ' + this.getPrID('init'));
				}
			},

			onCapped: function(o) {
				MAL.Util.log('RMV: Capped Experience: ' + this.getPrID('capped'));
				this.staticReason = 'capped';
			},

			onVideoLoadingBar: function() {
				MAL.Util.log('RMV: Showing Loading Bar: ' + this.getPrID('videoloadingbar'));
			},

			onVideoAutoPlay: function() {
				MAL.Util.log('RMV: Autoplay: ' + this.getPrID('videoautoplay'));
			},

			onVideoLoadingPlay: function() {
				MAL.Util.log('RMV: Loading Play: ' + this.getPrID('videoloadingplay'));
			},

			onVideoEnded: function() {
				MAL.Util.log('RMV: Video Ended: ' + this.getPrID('videoended'));
			},

			onStatic: function() {
				MAL.Util.log('RMV: Static: ' + this.getPrID('static'));
			},

			onCollapse: function() {
				MAL.Util.log('RMV: Collapse: ' + this.getPrID('collapse'));
			},

			onClose: function() {
				MAL.Util.log('RMV: Close: ' + this.getPrID('close'));
			},

			onHide: function() {
				MAL.Util.log('RMV: Hide: ' + this.getPrID('hide'));
			},

			onOptIn: function() {
				MAL.Util.log('RMV: Opt-in: ' + this.getPrID('optin'));
			},

			onReplay: function() {
				MAL.Util.log('RMV: Replay: ' + this.getPrID('replay'));
			},

			onClickForSound: function() {
				MAL.Util.log('RMV: Click For Sound: ' + this.getPrID('clickforsound'));
				this.clickedForSound = true;
			},

			onAutoPreload: function() {
				MAL.Util.log('RMV: Auto Preload: ' + this.getPrID('autopreload'));
			},

			onDidNotShow: function() {
				MAL.Util.log('RMV: Did Not Show: ' + this.getPrID('didnotshow'));
			},

			onClickthrough: function() {
				// Add click tracking here...

				var url = this.getBaseUrl() + MAL.placement.siteCode;
				var creativeType = 'v';

				if (this.staticReason === 'browser') {
					window.open(url + '-dsps');
					MAL.Util.log('RMV: Clickthrough Static');
					return;
				} else if (this.staticReason === 'speed') {
					creativeType = 's';
				} else if (this.staticReason === 'capped') {
					creativeType = 'c';
				}

				var label = 'clickthrough-' + ((this.cached) ? '-cache' : '-nocache') + ((this.clickedForSound) ? '-sound' : '-nosound');
				MAL.log(url);
				MAL.log(label);
				window.open(url, 'new');
			}
		}
	}));
};

var MALRMV = MALRMVBlank;