/*global MALPaths,MAL,MALChangeset,prActivity,pr_trk,prup,PRPID,prTrackActivity*/
var MALRMVPointroll = function() {

	var clickURLS = {
		us: '',
		cafr: 'ca/fr/',
		caen: 'ca/'
	};

	var creativeCodes = {
		MightyZeus: 'mz'
	};

	MAL.define('rmv', new MAL.services.MarcomProxy({

		videoPercentage: 0,
		cached: false,
		staticReason: false,
		clickedForSound: false,

		paths: {
			images: window.MALPaths ? MALPaths.images : './images/',
			videos: window.MALPaths ? MALPaths.videos : './videos/',
			scripts: window.MALPaths ? MALPaths.scripts : './'
		},

		deviceIDPool: {
			'small': 100, // Reserves 100-199
			'medium': 200, // Reserves 200-299
			'large': 300, // Reserves 300-399
			'mobile': 400, // Reserves 400-499
			'tablet': 500 // Reserves 500-599
		},

		eventIDs: {
			//Not User Initiated
			'init': 101001,
			'capped': 101002,
			'videoloadingbar': 101003,
			'videoautoplay': 101004,
			'videoloadingplay': 101005,
			'videoended': 101006,
			'static': 101007,
			'richmedia': 101008,
			'didnotshow': 101009,
			'autopreload': 101010,
			//User Initiated
			'collapse': 0,
			'hide': 1,
			'resize': 2,
			'clickthrough': 3,
			'optin': 4,
			'replay': 5,
			'clickforsound': 6,
			'close': 7
		},

		setDeviceSize: function(size) {
			if (MAL.isUndefined(this.deviceIDPool[size])) {
				MAL.Util.log("RMV: Set device size [" + size + "] does not exist in pool");
			} else {
				this.creativeSize = size;
			}
		},

		getPrID: function(eventName) {
			if (MAL.isUndefined(this.eventIDs[eventName])) {
				MAL.Util.log("RMV: Event [" + eventName + "] does not exist");
			}
			if (MAL.isUndefined(this.creativeSize)) {
				return this.eventIDs[eventName];
			}

			return this.deviceIDPool[this.creativeSize] + this.eventIDs[eventName];
		},

		isRMVReady: function() {
			return true; //window.prsw && window.prgo;
		},

		filePathProxy: function(filepath, filename) {
			// every file request goes through this method, this is where you would add additional filepath logic
			return filepath + filename;
		},

		baseUrl: {
			MightyZeus: [
				[0, 'http://www.apple.com/?']
			],
		},

		getBaseUrl: function() {
			var self = this;

			return this.baseUrl[window.MALCreative].reduce(function(p, c) {
				return p;
			}, this.baseUrl[window.MALCreative][0][1]);

		},

		events: {

			onDeviceSize: {
				handler: function(size) {
					MAL.Util.log("RMV: Set Device Size: " + size);
					this.setDeviceSize(size);
					prActivity(this.getPrID('resize'));
				}
			},

			onInit: {
				unique: true,
				handler: function(o) {
					this.creativeVersion = o.video;
					MAL.Util.log('RMV: Init: ' + this.getPrID('init'));
					prActivity(this.getPrID('init'));
				}
			},

			onCapped: function() {
				MAL.Util.log('RMV: Capped Experience: ' + this.getPrID('capped'));
				this.staticReason = 'capped';
				prActivity(this.getPrID('capped'));
			},

			onVideoLoadingBar: function() {
				MAL.Util.log('RMV: Showing Loading Bar: ' + this.getPrID('videoloadingbar'));
				prActivity(this.getPrID('videoloadingbar'));
			},

			onVideoAutoPlay: function() {
				MAL.Util.log('RMV: Autoplay: ' + this.getPrID('videoautoplay'));
				prActivity(this.getPrID('videoautoplay'));
			},

			onVideoLoadingPlay: function() {
				MAL.Util.log('RMV: Loading Play: ' + this.getPrID('videoloadingplay'));
				prActivity(this.getPrID('videoloadingplay'));
			},

			onVideoEnded: function() {
				MAL.Util.log('RMV: Video Ended: ' + this.getPrID('videoended'));
				prActivity(this.getPrID('videoended'));
			},

			onStatic: function() {
				MAL.Util.log('RMV: Static: ' + this.getPrID('static'));
				prActivity(this.getPrID('static'));
			},

			onCollapse: function() {
				MAL.Util.log('RMV: Collapse: ' + this.getPrID('collapse'));
				prActivity(this.getPrID('collapse'));
			},

			onClose: function() {
				MAL.Util.log('RMV: Close: ' + this.getPrID('close'));
				prActivity(this.getPrID('close'));
			},

			onHide: function() {
				MAL.Util.log('RMV: Hide: ' + this.getPrID('hide'));
				prActivity(this.getPrID('hide'));
			},

			onOptIn: function() {
				MAL.Util.log('RMV: Opt-in: ' + this.getPrID('optin'));
				prActivity(this.getPrID('optin'));
			},

			onReplay: function() {
				MAL.Util.log('RMV: Replay: ' + this.getPrID('replay'));
				prActivity(this.getPrID('replay'));
			},

			onClickForSound: function() {
				MAL.Util.log('RMV: Click For Sound: ' + this.getPrID('clickforsound'));
				prActivity(this.getPrID('clickforsound'));
				this.clickedForSound = true;
			},

			onAutoPreload: function() {
				MAL.Util.log('RMV: Auto Preload: ' + this.getPrID('autopreload'));
				prActivity(this.getPrID('autopreload'));
			},

			onDidNotShow: function() {
				MAL.Util.log('RMV: Did Not Show: ' + this.getPrID('didnotshow'));
				prActivity(this.getPrID('didnotshow'));
			},

			onClickthrough: function() {
				// Add click tracking here...
				var url = this.getBaseUrl();

				if (this.staticReason === 'browser') {
					window.open(url, 'new');
					pr_trk('pc', prup, 5, 1);
					// MAL.Util.log('RMV: Clickthrough', this.bandwidth);
					return;
				}

				if (!this.cached) {
					// doing clickthrough tracking with real bandwidth
					if (this.clickedForSound) {
						pr_trk('pc', prup, 1, 1);
					} else {
						pr_trk('pc', prup, 2, 1);
					}
				} else {
					// doing clickthrought with cached bandwidth

					if (this.clickedForSound) {
						pr_trk('pc', prup, 3, 1);
					} else {
						pr_trk('pc', prup, 4, 1);
					}
				}
				window.open(url, 'new');
			}
		}

	}));

	if (!MAL.isUndefined(window.MALChangeset)) {
		MAL.rmv.paths = {
			images: 'http://speed.pointroll.com/clients/apple/marcom/2014/mightyzuesmidpage/r' + MALChangeset + '/',
			videos: 'http://speed.pointroll.com/clients/apple/marcom/2014/mightyzuesmidpage/r' + MALChangeset + '/',
			scripts: 'http://speed.pointroll.com/clients/apple/marcom/2014/mightyzuesmidpage/r' + MALChangeset + '/'
		};
	}
};

var MALRMV = MALRMVPointroll;