/*global MALPaths,MALChangeset,EW300x250*/
var testing = window.EB === undefined; ///set testing variable to true for local testing
var tracking;
var images, scripts, videos, EB;

if(testing)
{
	EB = {
		automaticEventCounter:function(str){console.log("rmv track interaction: "+str);},
		userActionCounter:function(str){console.log("rmv track interaction: "+str);},
		getAssetUrl:function(str){return str;},
		clickthrough:function(type, url){return window.open(url);},

		_adConfig: { customJSVars: {} }		// testing config settings
	};

	images = window.MALPaths ? MALPaths.images : './images/';
	videos = window.MALPaths ? MALPaths.videos : './videos';
	scripts = window.MALPaths ? MALPaths.scripts : './scripts/';

} else {
	images = EB._dsBasePath + EB._adConfig.assets["index.html"].dsPath.split("//")[0] + "/";
	scripts = EB._dsBasePath + EB._adConfig.assets["index.html"].dsPath.split("//")[0] + "/";
	videos = EB._dsBasePath + EB._adConfig.assets["index.html"].dsPath.split("//")[0] + "/";
}

EB.automaticEventCounter("HTML5 JS file loaded");

/*global MAL*/
var MALRMVMediamind = function(){

	MAL.define('rmv', new MAL.services.MarcomProxy({
		
		debug: false,
		tracking:tracking,
		videoPercentage: 0,
		cached: false,
		staticReason: false,
		clickedForSound: false,

		paths: {
			images: images,
			scripts: scripts,
			videos: videos
		},

		isRMVReady: function () {
			return true;
		},

		filePathProxy: function (filepath, filename) {
			// every file request goes through this method, this is where you would add additional filepath logic
			//return filepath + filename;
			return EB.getAssetUrl(filepath+filename);
		},

		bwNames : [[0,'0-0.5m'],[512,'0.5-1m'],[1000,'1-2m'],[2000,'2-3m'],[3000,'3-4m'],[4000,'4-5m'],[5000,'5-6m'],[6000,'6-7m'],[7000,'7-8m'],[8000,'8-9m'],[9000,'9-10m'],[10000,'10m']],

		baseUrl : {
			MightyZeus: [[0, 'http://www.apple.com/macbook/?cid=wwa-' + MAL.placement.geo + '-disp-mac-div-']],
        },

		getBandwidthNumber: function () {
			var self = this;
			
			return this.bwNames.reduce(function (p,c) {		
				return (self.bandwidth >= c[0]) ? c[0] : p;
			},this.bwNames[0][0]);
		},

		getBandwidthString: function () {
			var self = this;

			return this.bwNames.reduce(function (p,c) {		
				return (self.bandwidth >= c[0]) ? c[1] : p;
			},this.bwNames[0][1]);
		},

		getBaseUrl: function () {
			var self = this;

			return this.baseUrl[window.MALCreative].reduce(function (p,c) {
				return (self.bandwidth >= c[0]) ? c[1] : p;
			},this.baseUrl[window.MALCreative][0][1]);
		},

		events : {

			onInit: {
				unique: true,
				handler: function (o) {					
					this.creativeVersion = o.video;
					MAL.Util.log('RMV: Init');
					EB.automaticEventCounter("Init");
				}
			},

			onCapped: function () {
				this.staticReason = 'capped';
				MAL.Util.log('RMV: Capped Experience');	
				EB.automaticEventCounter("Capped Experience");
			},

			onVideoLoadingBar: function () {
				MAL.Util.log('RMV: Showing Loading Bar');
				EB.automaticEventCounter('Showing Loading Bar');
			},

			onVideoAutoPlay: function () {
				MAL.Util.log('RMV: Autoplay');
				EB.automaticEventCounter('Autoplay');
			},

			onVideoLoadingPlay: function () {
				MAL.Util.log('RMV: Loading Play');
				EB.automaticEventCounter('Loading Play');
			},

			onVideoEnded: function () {
				MAL.Util.log('RMV: Video Ended');
				EB.automaticEventCounter('Video Ended');
			},

			onStatic: function (obj) {
				if(obj) {
					this.staticReason = obj.reason;
					MAL.Util.log('RMV: Static',obj.reason);
				} else {
					MAL.Util.log('RMV: Static');
				}				
				EB.automaticEventCounter('Static');
			},

			onClickForSound: function () {
				this.clickedForSound = true;
				MAL.Util.log('RMV: Click For Sound');				
				EB.userActionCounter('Click For Sound');
			},

			onClickthrough: function () {
				// Add click tracking here...
				
				var url = this.getBaseUrl() + MAL.placement.siteCode;
				var creativeType = 'v';

				if (this.staticReason === 'browser') {
					MAL.Util.log('RMV: Clickthrough Static');
					EB.userActionCounter("Clickthrough Static");
					EB.clickthrough('Clickthrough Static', url + '-dsps');
					return;
				} else if (this.staticReason === 'speed') {
					creativeType = 's';
				} else if (this.staticReason === 'capped') {
					creativeType = 'c';
				}
				
				// this section does not get executed
				// it lists out the custom exit event labels
				if(1===0){
					EB.clickthrough('Clickthrough Static');
					EB.clickthrough('Clickthrough With Sound 0-0.5m');
					EB.clickthrough('Clickthrough With Sound 0.5-1m');
					EB.clickthrough('Clickthrough With Sound 1-2m');
					EB.clickthrough('Clickthrough With Sound 2-3m');
					EB.clickthrough('Clickthrough With Sound 3-4m');
					EB.clickthrough('Clickthrough With Sound 4-5m');
					EB.clickthrough('Clickthrough With Sound 5-6m');
					EB.clickthrough('Clickthrough With Sound 6-7m');
					EB.clickthrough('Clickthrough With Sound 7-8m');
					EB.clickthrough('Clickthrough With Sound 8-9m');
					EB.clickthrough('Clickthrough With Sound 9-10m');
					EB.clickthrough('Clickthrough With Sound 10m');
					EB.clickthrough('Clickthrough Without Sound 0-0.5m');
					EB.clickthrough('Clickthrough Without Sound 0.5-1m');
					EB.clickthrough('Clickthrough Without Sound 1-2m');
					EB.clickthrough('Clickthrough Without Sound 2-3m');
					EB.clickthrough('Clickthrough Without Sound 3-4m');
					EB.clickthrough('Clickthrough Without Sound 4-5m');
					EB.clickthrough('Clickthrough Without Sound 5-6m');
					EB.clickthrough('Clickthrough Without Sound 6-7m');
					EB.clickthrough('Clickthrough Without Sound 7-8m');
					EB.clickthrough('Clickthrough Without Sound 8-9m');
					EB.clickthrough('Clickthrough Without Sound 9-10m');
					EB.clickthrough('Clickthrough Without Sound 10m');
					EB.clickthrough('Clickthrough Cached With Sound 0-0.5m');
					EB.clickthrough('Clickthrough Cached With Sound 0.5-1m');
					EB.clickthrough('Clickthrough Cached With Sound 1-2m');
					EB.clickthrough('Clickthrough Cached With Sound 2-3m');
					EB.clickthrough('Clickthrough Cached With Sound 3-4m');
					EB.clickthrough('Clickthrough Cached With Sound 4-5m');
					EB.clickthrough('Clickthrough Cached With Sound 5-6m');
					EB.clickthrough('Clickthrough Cached With Sound 6-7m');
					EB.clickthrough('Clickthrough Cached With Sound 7-8m');
					EB.clickthrough('Clickthrough Cached With Sound 8-9m');
					EB.clickthrough('Clickthrough Cached With Sound 9-10m');
					EB.clickthrough('Clickthrough Cached With Sound 10m');
					EB.clickthrough('Clickthrough Cached Without Sound 0-0.5m');
					EB.clickthrough('Clickthrough Cached Without Sound 0.5-1m');
					EB.clickthrough('Clickthrough Cached Without Sound 1-2m');
					EB.clickthrough('Clickthrough Cached Without Sound 2-3m');
					EB.clickthrough('Clickthrough Cached Without Sound 3-4m');
					EB.clickthrough('Clickthrough Cached Without Sound 4-5m');
					EB.clickthrough('Clickthrough Cached Without Sound 5-6m');
					EB.clickthrough('Clickthrough Cached Without Sound 6-7m');
					EB.clickthrough('Clickthrough Cached Without Sound 7-8m');
					EB.clickthrough('Clickthrough Cached Without Sound 8-9m');
					EB.clickthrough('Clickthrough Cached Without Sound 9-10m');
					EB.clickthrough('Clickthrough Cached Without Sound 10m');
				}
				// end list of labels
				var studioExitLabel = '';

				if (!this.cached) {
					if (this.clickedForSound) {						
						MAL.Util.log('RMV: Clickthrough With Sound',this.bandwidth);
						studioExitLabel = 'Clickthrough With Sound ' + this.getBandwidthString();
					} else {						
						MAL.Util.log('RMV: Clickthrough Without Sound',this.bandwidth);
						studioExitLabel = 'Clickthrough Without Sound ' + this.getBandwidthString();
					}					
					url += '-nb' + this.getBandwidthString() + '-c0-dsp' + creativeType;
				} else {
					if (this.clickedForSound) {						
						MAL.Util.log('RMV: Clickthrough Cached With Sound',this.bandwidth);
						studioExitLabel = 'Clickthrough Cached With Sound ' + this.getBandwidthString();
					} else {						
						MAL.Util.log('RMV: Clickthrough Cached Without Sound',this.bandwidth);
						studioExitLabel = 'Clickthrough Cached Without Sound ' + this.getBandwidthString();
					}					
					url += '-nb' + this.getBandwidthString() + '-c1-dsp' + creativeType;
				}

			//	EB.userActionCounter(studioExitLabel); 
				EB.clickthrough(studioExitLabel, url);	// pass url?
			},

			onBandwidth: {
				unique: true,
				handler: function (o) {
					o.bandwidth += 400;

					this.bandwidth = Math.floor(o.bandwidth);

					// this section does not get executed
					// it lists out the custom exit event labels for Studio
					if(1===0){
						EB.userActionCounter('Bandwidth 0-0.5m');
						EB.userActionCounter('Bandwidth 0.5-1m');
						EB.userActionCounter('Bandwidth 1-2m');
						EB.userActionCounter('Bandwidth 2-3m');
						EB.userActionCounter('Bandwidth 3-4m');
						EB.userActionCounter('Bandwidth 4-5m');
						EB.userActionCounter('Bandwidth 5-6m');
						EB.userActionCounter('Bandwidth 6-7m');
						EB.userActionCounter('Bandwidth 7-8m');
						EB.userActionCounter('Bandwidth 8-9m');
						EB.userActionCounter('Bandwidth 9-10m');
						EB.userActionCounter('Bandwidth 10m');
						EB.userActionCounter('Bandwidth Cached 0-0.5m');
						EB.userActionCounter('Bandwidth Cached 0.5-1m');
						EB.userActionCounter('Bandwidth Cached 1-2m');
						EB.userActionCounter('Bandwidth Cached 2-3m');
						EB.userActionCounter('Bandwidth Cached 3-4m');
						EB.userActionCounter('Bandwidth Cached 4-5m');
						EB.userActionCounter('Bandwidth Cached 5-6m');
						EB.userActionCounter('Bandwidth Cached 6-7m');
						EB.userActionCounter('Bandwidth Cached 7-8m');
						EB.userActionCounter('Bandwidth Cached 8-9m');
						EB.userActionCounter('Bandwidth Cached 9-10m');
						EB.userActionCounter('Bandwidth Cached 10m');
					}

					if (MAL.Environment.hasLocalStorage) {
						if (localStorage.getItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode)) {
							this.cached = true;
							this.bandwidth = parseInt(localStorage.getItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode),0);
							MAL.Util.log('RMV: Bandwidth Cached',this.bandwidth);
							EB.userActionCounter('Bandwidth Cached ' + this.getBandwidthString());
						} else {
							try {
								localStorage.setItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode,this.bandwidth);
								MAL.Util.log('RMV: BandWidth',this.bandwidth);
								EB.userActionCounter('Bandwidth ' + this.getBandwidthString());
							} catch (e) {
								return false;
							}
						}
					}
				}
			}
		}
	}));

	if (!MAL.isUndefined(window.MALChangeset) && !testing) {
		MAL.rmv.paths = {
			images: EB._dsBasePath + EB._adConfig.assets["index.html"].dsPath.split("//")[0] + "/",
			videos: EB._dsBasePath + EB._adConfig.assets["index.html"].dsPath.split("//")[0] + "/",
			scripts: EB._dsBasePath + EB._adConfig.assets["index.html"].dsPath.split("//")[0] + "/"
		};
	}

// -------------------------------
};

var MALCreative = EB._adConfig.customJSVars.MALCreative || 'MightyZeus';	// default to Detroit if config var isnt set
var MALRMV = MALRMVMediamind;
