/**
 * @class MAL
 * @singleton
 */
window.MAL = window.MAL || {
	define: function (path, value) {
		var current = this;

		path = path.split('.');

		path.forEach(function (segment, key) {
			if (!MAL.isObject(current)) {
				throw new Error('trying to store a value into a ' + typeof current);
			} else if (!(segment in current)) {
				current = current[segment] = key === path.length-1 ? value : (Object.create ? Object.create(null) : {});

				if (value.prototype) {
					value.prototype.objectClassName = segment;
					value.prototype.objectClassPath = path;
					value.prototype.objectClassPathToken = path.join('.').toLowerCase();
				}
			} else {
				if (key === path.length-1) {
					current[segment] = value;
				} else {
					current = current[segment];
				}
			}
		}, this);
	},

	get: function (path) {
		var current = this;

		path = path.split('.');

		for (var key = 0, segment; key < path.length; key++) {
			segment = path[key];

			if (key === path.length-1) {
				return current[segment];
			} else {
				if (!current[segment]) return undefined;
				current = current[segment];
			}
		}

		return undefined;
	}
};