/**
 * @author Chad Scira <chad@mediaartslab.com>
 * @docauthor Chad Scira <chad@mediaartslab.com>
 *
 * Map class. List of key-value pairs where both the key and the value can be of any type.
 *
 * # Usage
 *
 *     // adding and obtaining the layer
 *     var positions = new MAL.Map();
 *     items.set(123, 'test');
 *     items.get(123);
 *     items.remove(123);
 *
 * @class MAL.Map
 */
MAL.define('Map', MAL.Util.create({
	initialize: function () {
		this._keys = [];
		this._values = [];
	},

	/**
	 * set item in Map
	 *
	 *     items.set(123, 'key', 'test');
	 *
	 * @param {Object} reference
	 * @param {String} key
	 * @param {Object} value
	 */
	set: function (reference, value) {
		var index = this._keys.indexOf(reference),
			data;

		if (index === -1) {
			index = this._keys.length;

			this._keys.push(reference);
		}

		this._values[index] = value;
	},

	/**
	 * remove item from the Map
	 *
	 *     items.remove(123);
	 *
	 * @param {Object} reference
	 * @param {String} key
	 */
	remove: function (reference) {
		var index = this._keys.indexOf(reference);

		if (index === -1) return;

		this._keys.splice(index, 1);
		this._values.splice(index, 1);
	},

	/**
	 * get item from the Map
	 *
	 *     items.get(123);
	 *
	 * @param {Object} reference
	 * @param {String} key
	 */
	get: function (reference) {
		var index = this._keys.indexOf(reference);

		if (index === -1) return undefined;

		return this._values[index];
	}
}));