/**
 * @author Chad Scira <chad@mediaartslab.com>
 * @docauthor Chad Scira <chad@mediaartslab.com>
 *
 * ViewStyle is a Style object that is made to be used directly inside of {@link MAL.View}, the interface remains exactly the same as {@link MAL.Style}
 *
 * @class MAL.ViewStyle
 * @extends MAL.Style
 */
MAL.define('ViewStyle', MAL.Style.extend({
	/**
	 * initializes MAL.ViewStyle
	 *
	 *     var style = new MAL.ViewStyle({
	 *       body: {
	 *         background: '#ccc'
	 *       }
	 *     });
	 *
	 * @method constructor
	 * @param {Object} config
	 */

	/**
	* @cfg {String} prefix
	* the className prefix (defaults to mal-ad-)
	*/

	/**
	* @cfg {Boolean} raw
	* if you set raw to true the rules will not have auto prefixed properties
	*/

	/**
	* @cfg {Object} defaults
	* an object of default rules
	*/

	/**
	* @cfg {Function} filePathProxy
	* event loop delay in milliseconds
	*/

	/**
	* @cfg {String} imagePath
	* event loop delay in milliseconds
	*/
	initialize: function (rules, $config) {
		$config = $config || {};

		this.view = $config.view;
		this.instanceRules = {};

		this._super(rules, MAL.mergeOptions({prefix: this.view.prefix, selectorPrefix: '.mal-view.' + this.view.prefix.substr(0, this.view.prefix.length-1) + ' '}, $config));

		this._parseInstanceRules();
	},

	/**
	 * @private
	 */
	_parseInstanceRules: function () {
		for (var rule in this.rules) {
			if (rule.match(/@instance/)) {
				this.instanceRules[rule.replace(/@instance/, '#mal-view' + this.view.id)] = this.rules[rule];
				delete this.rules[rule];
			}
		}
	}
}));