/*globals MAL*/
/**
 * @author Chad Scira <chad@mediaartslab.com>
 * @docauthor Chad Scira <chad@mediaartslab.com>
 *
 * **WARNING: this has yet to be finalized**
 *
 * @class MAL.canvas.Layer
 * @extends MAL.Object
 */

/**
 * dispatched when a tween has been started
 *
 * @event tweenstart
 * @param {Event} this
 */
MAL.define('canvas.Layer', MAL.Object.extend({
	/**
	 * initializes MAL.canvas.Layer
	 *
	 * @method constructor
	 * @param {Object} config
	 */
	initialize: function ($config) {
		this._super();

		this.name = $config.name;
		this._tweens = [];
		this._currentTween = null;
		this._animating = false;
		this._values = {};
		this._stage = $config.stage;
	},

	type: 'raw',

	/**
	 * starts the next tween if one exists
	 *
	 * @private
	 */
	_startNextTween: function () {
		if (this._tweens.length) {
			// get new tween
			this._currentTween = this._tweens.shift();

			// update start values if not provided
			this._currentTween.start = this._currentTween.start || {};
			for (var i in this._currentTween.finish) if (!this._currentTween.start[i] && this._values[i]) this._currentTween.start[i] = this._values[i];

			// initialize tween
			this._currentTween = new MAL.canvas.Tween(this._currentTween);
			this._animating = true;

			// notify stage that we are animating again
			this.dispatchEvent('tweenstart');
		} else {
			this._currentTween = null;
			this._animating = false;
			return false;
		}
	},

	/**
	 * updates layer if it has a tween running
	 *
	 * @param {Number} time
	 * @return {Object} values
	 */
	update: function (time) {

		if (!this._animating && this._stage.started && this._tweens.length) this._startNextTween();

		if (!this._currentTween) return null;

		var values = this._currentTween.update(time);

		if (values) {
			for (var value in values) this._values[value] = values[value];
		} else if (values === null) {
			var callback = this._currentTween.callback;
			this._animating = false;
			this._currentTween = null;
			if (!this._tweens.length && callback) callback();
		}

		return this._values;
	},

	/**
	 * add tween
	 *
	 * @param {Object} tween
	 */
	addTween: function ($options, calledDirectly) {
		this._tweens.push($options);

		if (!calledDirectly && !this._animating) this._startNextTween();
	},

	/**
	 * add multiple tweens
	 *
	 * @param {Object...} tweens
	 */
	addTweenSet: function () {

		for (var tween = 0; tween < arguments.length; tween++) this.addTween(arguments[tween], true);

		if (!this._animating) this._startNextTween();
	}
}));