/*globals MAL*/
/**
 * @author Chad Scira <chad@mediaartslab.com>
 * @docauthor Chad Scira <chad@mediaartslab.com>
 *
 * **WARNING: this has yet to be finalized**
 *
 * @class MAL.canvas.ShapeLayer
 * @extends MAL.canvas.Layer
 */

/**
 * dispatched when a tween has been started
 *
 * @event tweenstart
 * @param {Event} this
 */
MAL.define('canvas.ShapeLayer', MAL.canvas.Layer.extend({
	/**
	 * initializes MAL.canvas.ShapeLayer
	 *
	 * @method constructor
	 */
	initialize: function ($config) {
		this._super($config);

		this._shape = null;
		this.points = null;
		this.values = {};

		this._createShape($config.shapeOptions);
	},

	type: 'shape',

	draw: function (context) {
		MAL.Shape.prototype.draw.call(this._shape, context);
	},

	_defaultValues: {
		scale: 1,
		x: 0,
		y: 0,
		opacity: 1
	},

	_shapeOptions: ['shape', 'anchor'],

	_createShape: function (shapeOptions) {
		// remove shape options and add to instance
		for (var option in shapeOptions) if (this._shapeOptions.indexOf(option) === -1) {
			this[option] = shapeOptions[option];
			delete shapeOptions[option];
		}

		this._shape = new MAL.Shape(shapeOptions);
		this.points = this._shape.transform({});
	},

	/**
	 * starts the next tween if one exists
	 *
	 * @private
	 */
	_startNextTween: function () {
		if (this._tweens.length) {
			// get new tween
			this._currentTween = this._tweens.shift();

			// update start values if not provided
			this._currentTween.start = this._currentTween.start || {};
			for (var i in this._currentTween.finish) {
				if (MAL.isUndefined(this._currentTween.start[i]) && MAL.isUndefined(this._values[i]) && this._defaultValues[i]) this._currentTween.start[i] = this._defaultValues[i];
				if (MAL.isUndefined(this._currentTween.start[i]) && this._values[i]) this._currentTween.start[i] = this._values[i];
			}

			// initialize tween
			this._currentTween = new MAL.canvas.Tween(this._currentTween);
			this._animating = true;

			// notify stage that we are animating again
			this.dispatchEvent('tweenstart');
		} else {
			this._currentTween = null;
			this._animating = false;
			return false;
		}
	},

	/**
	 * updates layer if it has a tween running
	 *
	 * @param {Number} time
	 * @return {Object} values
	 */
	update: function (time) {

		if (!this._animating && this._stage.started && this._tweens.length) this._startNextTween();

		if (!this._currentTween) return null;

		var values = this._currentTween.update(time);

		if (values) {
			for (var value in values) this._values[value] = values[value];
		} else if (values === null) {
			var callback = this._currentTween.callback;
			this._animating = false;
			this._currentTween = null;
			if (!this._tweens.length && callback) callback();
		}

		this.points = this._shape.transform(this._values);
		this.values = this._values;

		return true;
	}
}));