/*globals MAL*/
/**
 * @author Chad Scira <chad@mediaartslab.com>
 * @docauthor Chad Scira <chad@mediaartslab.com>
 *
 * **WARNING: this has yet to be finalized**
 *
 * Stage class. Provides an animation environment for canvas layers ({@link MAL.canvas.Layer})
 *
 * @class MAL.canvas.Stage
 * @extends MAL.Object
 */

/**
 * dispatched when the canvas shoul be redrawn
 *
 * @event update
 * @param {Event} this
 */
MAL.define('canvas.Stage', MAL.Object.extend({
	/**
	 * initializes MAL.canvas.Stage
	 *
	 * @method constructor
	 */

	/**
	 * @cfg {Function} update callback function
	 */

	/**
	 * @cfg {Function} fps overides default draw rate
	 */
	initialize: function ($config) {
		this._super();

		$config = $config || {};

		this._fps = $config.fps;
		this._layers = [];
		this._timeout = null;
		this._layerGroups = {};
		this._layersCurrentDict = {};
		this._layersDict = {};
		this._animatingDict = {};
		this._animatingShapeDict = {};
		this._destroyed = false;
		this._looping = false;
		this.started = false;
	},

	/**
	 * update loop
	 *
	 * @private
	 */
	_loop: function () {
		clearTimeout(this._timeout);
		if (!this.started) return;

		var time = Date.now();

		this._layers = this._layers.filter(function (layer) {

			var current = layer.update(time);

			if (!current) {
				return false;
			} else {
				if (layer.name && layer.type === 'shape') {
					this._animatingShapeDict[layer.name] = layer;
				} else if (layer.name) {
					this._animatingDict[layer.name] = current;
				}
				return true;
			}
			return true;
		}, this);

		// break loop if we have nothing to animate on
		if (!this._layers.length) {
			clearTimeout(this._timeout);
			this._looping = false;
			return;
		}

		this.dispatchEvent('update', {layers: this._animatingDict, shapes: this._animatingShapeDict});

		if (!this._fps && MAL.Environment.requestAnimationFrame) {
			window[MAL.Environment.requestAnimationFrame](this._loop);
		} else {
			window.clearTimeout(this._timeout);
			this._timeout = window.setTimeout(this._loop, 1000 / this._fps);
		}

		this._looping = true;
	},

	/**
	 * get a layer reference by name
	 *
	 * @param {String} name
	 * @return {MAL.canvas.Layer}
	 */
	getLayer: function (name) {
		if (this._layersDict[name]) {
			return this._layersDict[name];
		} else {
			return this._layersDict[name] = this.addLayer(name);
		}
	},

	/**
	 * add a layer to the canvas stage
	 *
	 * @param {String} name
	 * @param {Object} options
	 * @return {MAL.canvas.Layer}
	 */
	addLayer: function (name) {
		var $options = {};
		$options.name = name;
		$options.stage = this;

		var layer = this._layersDict[$options.name] =new MAL.canvas.Layer($options);
		layer.addEventListener('tweenstart', this._tweenStarted);
		return layer;
	},

	/**
	 * remove layer by name from stage
	 *
	 * @param {String} name
	 */
	destroyLayer: function (name) {
		var layer = this.getLayer(name),
			index = this._layers.indexOf(layer);

		if (index !== -1) this._layers.splice(index, 1);

		if (layer.type === 'shape') {
			delete this._animatingShapeDict[name];
		} else {
			delete this._animatingDict[name];
		}

		this.dispatchEvent('update', {layers: this._animatingDict, shapes: this._animatingShapeDict});
	},

	/**
	 * add/create shape layer
	 *
	 * @param {String} name
	 * @param {Object} shapeOptions
	 * @return {MAL.canvas.ShapeLayer}
	 */
	addShapeLayer: function (name, shapeOptions) {
		var $options = {};
		$options.name = name;
		$options.stage = this;
		$options.shapeOptions = shapeOptions;

		var layer = this._layersDict[$options.name] = new MAL.canvas.ShapeLayer($options);
		layer.addEventListener('tweenstart', this._tweenStarted);
		return layer;
	},

	/**
	 * starts the stage animation loop
	 */
	start: function () {
		this.started = true;
		this._loop();
		this._layers.forEach(function (layer) {
			if (!layer._animating) layer.start();
		});
	},

	/**
	 * adds layer to the layers array if it is not already there
	 *
	 * @private
	 */
	_tweenStarted: function (layer) {
		if (this._layers.indexOf(layer) === -1) this._layers.push(layer);
		if (!this._looping) this._loop();
	},

	/**
	 * stops the stage animation loop
	 */
	stop: function () {
		this.started = false;
	}
}));