/*globals MAL*/
/**
 * @author Chad Scira <chad@mediaartslab.com>
 * @docauthor Chad Scira <chad@mediaartslab.com>
 *
 * **WARNING: this has yet to be finalized**
 *
 * @class MAL.canvas.Tween
 * @extends MAL.Object
 */

MAL.define('canvas.Tween', MAL.Object.extend({
	/**
	 * initializes MAL.canvas.Tween
	 *
	 * @method constructor
	 */

	/**
	 * @cfg {Number} delay in seconds
	 */

	/**
	 * @cfg {Number} duration in seconds
	 */

	/**
	 * @cfg {String/Array/Function} easing for tween
	 */

	/**
	 * @cfg {Object} start options
	 */

	/**
	 * @cfg {Object} finish options
	 */

	/**
	 * @cfg {Function} callback for when tween is completed
	 */
	initialize: function ($config) {
		this._super();

		this._finished = false;
		this._destroy = false;
		this._delay = $config.delay * 1000 || 0;
		this._duration = $config.duration * 1000 || 1000;
		this._startTime = null;
		this._easing = $config.easing || [0.25, 0.1, 0.25, 1];
		if (MAL.isString(this._easing) && this._eases[this._easing]) this._easing = this._eases[this._easing];
		this._values = {
			start: $config.start || {},
			delta: {},
			current: {},
			finish: $config.finish
		};

		for (var i in this._values.finish) {
			if (!this._values.start[i]) this._values.start[i] = 0;
			this._values.delta[i] = this._values.finish[i] - this._values.start[i];
		}

		this.callback = $config.callback;

		this._startTime = new Date().getTime() + this._delay;
	},

	_eases: {
		ease: [0.25, 0.1, 0.25, 1],
		linear: [0, 0, 1, 1],
		'ease-in': [0.42, 0, 1, 1],
		'ease-out': [0, 0, 0.58, 1],
		'ease-in-out': [0.42, 0, 0.58, 1]
	},

	/**
	 * get a layer reference by name
	 *
	 * @param {Number} time
	 * @return {Object} values
	 */
	update: function (time) {
		if (this._destroy) return null;

		if (this._startTime >= time) return this._values.start;

		var finished = time > (this._startTime + this._duration),
			percent = (time - this._startTime) / this._duration;

		if (Array.isArray(this._easing)) {
			percent = MAL.Util.cubicBezierWithPercent(percent, this._easing[0], this._easing[1], this._easing[2], this._easing[3]);
		} else {
			percent = this._easing(percent);
		}

		if (percent > 1) percent = 1;

		this._percent = percent;

		for (var i in this._values.finish) {
			if (finished) {
				this._values.current[i] = this._values.finish[i];
			} else {
				this._values.current[i] = this._values.start[i] + (this._values.delta[i] * percent);
			}
		}

		if (finished) this._destroy = true;

		return this._values.current;
	}
}));