/**
 * MAL Namespace
 * @class MAL
 */
if (!('bind' in Function.prototype)) {
	/**
	 * @private
	 */
	Function.prototype.bind = function(){
		var fn = this, args = Array.prototype.slice.call(arguments), object = args.shift();
		return function(){ return fn.apply(object, args.concat(Array.prototype.slice.call(arguments)));	};
	};
}

// Copyright (c) Mozilla Foundation http://www.mozilla.org/ This code is available under the terms of the MIT License
if (!Array.prototype.map) {
	/**
	 * @private
	 */
	Array.prototype.map = function(fun /*, thisp*/) {
		var len = this.length;
		if (typeof fun !== "function") {
			throw new TypeError();
		}

		var res = new Array(len);
		var thisp = arguments[1];
		for (var i = 0; i < len; i++)
		{
			if (i in this) {
				res[i] = fun.call(thisp, this[i], i, this);
			}
		}

		return res;
	};
}

// Copyright (c) Mozilla Foundation http://www.mozilla.org/ This code is available under the terms of the MIT License
if (!Array.prototype.forEach) {
	/**
	 * @private
	 */
	Array.prototype.forEach = function(fun /*, thisp*/) {
		var len = this.length >>> 0;
		if (typeof fun !== "function") {
			throw new TypeError();
		}

		var thisp = arguments[1];
		for (var i = 0; i < len; i++) {
			if (i in this) {
				fun.call(thisp, this[i], i, this);
			}
		}
	};
}

// Copyright (c) Mozilla Foundation http://www.mozilla.org/ This code is available under the terms of the MIT License
if (!Array.prototype.indexOf) {
	/**
	 * @private
	 */
	Array.prototype.indexOf = function (searchElement /*, fromIndex */ ) {
		"use strict";
		if (this === void 0 || this === null) {
			throw new TypeError();
		}
		var t = this;
		var len = t.length >>> 0;
		if (len === 0) {
			return -1;
		}
		var n = 0;
		if (arguments.length > 0) {
			n = Number(arguments[1]);
			if (n !== n) { // shortcut for verifying if it's NaN
				n = 0;
			} else if (n !== 0 && n !== Infinity && n !== -Infinity) {
				n = (n > 0 || -1) * Math.floor(Math.abs(n));
			}
		}
		if (n >= len) {
			return -1;
		}
		var k = n >= 0 ? n : Math.max(len - Math.abs(n), 0);
		for (; k < len; k++) {
			if (k in t && t[k] === searchElement) {
				return k;
			}
		}
		return -1;
	};
}

if (!Function.prototype.bind) {
	// adds param support to setTimeout and setInterval older engines
	//
	//     var timeoutID = window.setTimeout(func, delay, [param1, param2, ...]);
	//     var intervalID = window.setInterval(func, delay, [param1, param2, ...]);
	(function () {

		function helper (method) {
			return function (func, timeout) {
				var args = Array.prototype.slice.call(arguments, 2);
				return method(function () {
					func.apply(null, args);
				}, timeout);
			};
		}

		window.setTimeout = helper(window.setTimeout);
		window.setInterval = helper(window.setInterval);
	}(window));
}