/**
 * @author Chad Scira <chad@mediaartslab.com>
 * @docauthor Chad Scira <chad@mediaartslab.com>
 *
 * creates a proxy object for layers that allows us to group operations through a simple interface
 *
 * @class MAL.tween.LayerProxy
 * @private
 */

/**
 * initializes MAL.tween.LayerProxy
 *
 * @method constructor
 * @param {Object} config
 */
MAL.define('tween.LayerProxy', function (object) {
	var Proxy = function ($config) {
		this.layers = $config.layers;
		this.layers.forEach(function (layer, key) {
			this[key] = layer;
		}, this);
	};

	Proxy.prototype = {
		/**
		 * will run function against all matching layers
		 *
		 *     $('One','Two').each(function (layer) {
		 *      console.log(layer);
		 *     });
		 *
		 * @param {Object} events
		 */
		each: function (callback) {
			this.layers.forEach(function (layer) {
				callback.call(layer, layer);
			});

			return this;
		}
	};

	for (var method in object.prototype) {
		// ensure that the methods are public
		if (method.substr(0,1) !== '_') {
			Proxy.prototype[method] = (function (method) {
				return function () {
					var args = MAL.toArray(arguments);

					this.layers.forEach(function (layer) {
						MAL.tween[layer.layerType + 'Layer'].prototype[method].apply(layer, MAL.clone(args, true));
					});

					return this;
				};
			}(method));
		}
	}

	return Proxy;
});