/**
 * @author Chad Scira <chad@mediaartslab.com>
 * @docauthor Chad Scira <chad@mediaartslab.com>
 *
 * Transform property object.
 *
 * **This is just a list of the properties you use with the setProperty methods**
 * 
 * @class MAL.tween.TransformObject
 */
 
/**
 * @property {Object} transformOrigin
 *
 * example of the default transform origin of 50% 50%
 *
 *     {x: .5, y: .5}
 *
 * currently transform origin **only works with scale** if the browser doesn't support native **-transform-origin**
 */
 
/**
 * @property {Number} x
 *
 * x absolute position
 */
 
/**
 * @property {Number} y
 *
 * y absolute position
 */
 
/**
 * @property {Number} z
 *
 * z absolute position (only works if 3d is supported)
 */
 
 /**
 * @property {Number} opacity
 *
 * uses filter if IE7 or IE8
 */
 
 /**
 * @property {Number} rotate
 *
 * example of a 90 degree rotation
 *
 *     {rotate: 90}
 *
 * uses filter if IE7 or IE8, you also shouldn't animate located if you are rotating. If you need to use a container.
 *
 * **make sure you are animating on an IMG tag and not a DIV if you want full cross browser support!**
 */
 
 /**
 * @property {Number} rotateX
 *
 * requires 3d support
 */
 
 /**
 * @property {Number} rotateY
 *
 * requires 3d support
 */
 
 /**
 * @property {Number} rotateZ
 *
 * requires 3d support
 */

 /**
 * @property {Number} preRotate
 *
 * happens before all other translation transformations
 */

/**
 * @property {Number} preRotateX
 *
 * happens before all other translation transformations
 */

/**
 * @property {Number} preRotateY
 *
 * happens before all other translation transformations
 */

/**
 * @property {Number} preRotateZ
 *
 * happens before all other translation transformations
 */

 /**
 * @property {Number} scale
 *
 * example of a 200% scale
 *
 *     {scale: 2} 
 *
 * for IE7 and IE8 it utilizes **width, height, left, and top** properties so you should wrap it in a container if you want to move it.
 */
 
 /**
 * @property {Number} scaleX
 *
 * for IE7 and IE8 it utilizes **width, and left** properties so you should wrap it in a container if you want to move it on the X.
 */
 
 /**
 * @property {Number} scaleY
 *
 * for IE7 and IE8 it utilizes **height, and top** properties so you should wrap it in a container if you want to move it on the Y.
 */
 
 /**
 * @property {Number} scaleZ
 *
 * requires 3d support
 */
 
 /**
 * @property {Number} width
 *
 * layer width
 */
 
 /**
 * @property {Number} height
 *
 * layer height
 */
 
 /**
 * @property {Number} left
 *
 * the **left** property differs from the **x** property because its not hardware accelerated because it doesn't use css transformations
 */
 
 /**
 * @property {Number} top
 *
 * the **top** property differs from the **y** property because its not hardware accelerated because it doesn't use css transformations
 */