function MALAdReadyCheck () {

	// do we have everything we need?
	if (
		!window.MALSite ||
		!window.MALRMV ||
		!document.getElementById('mal-ad-container') ||
		!window.MALCreative ||
		!window.MAL.connections ||

		(MAL.Environment.browser === 'firefox' && !(window.document.defaultView && window.document.defaultView.getComputedStyle && window.document.defaultView.getComputedStyle(document.getElementById('mal-ad-container'), '')))
	) {
		
		setTimeout(MALAdReadyCheck, 50);
		return;
	}

	// define MAL.placement and MAL.site
	if (!MAL.placement) window.MALSite();


	// supertag setup
	if (MAL.placement && MAL.placement.supertag) {

		MAL.supertag = new MAL.services.Supertag(MAL.placement.supertag);

		// wait until the page is ready
		MAL.supertag.addEventListener('page-ready', function(object, details) {
			console.log('PAGE IS READY');

			console.log('WINDOW SIZE:', details.windowSize);
			console.log('PAGE SCROLL:', details.pageScroll);
			console.log('BANNER RECT:', details.bannerRect);

			
			// set global collapse conditions
			var collapse = (details.windowSize.width < 700);

			if (collapse || MAL.placement.supertag.collapse) {
				
				MAL.supertag.collapse();

			} else {

				window.MALRMV();

				var stageConfig = {dualLayer: true};

				if(
					(MAL.Environment.browser === 'msie' && MAL.Environment.documentMode>9) ||
					((MAL.Environment.osVersion === 5.1 || MAL.Environment.osVersion === 5.2) && MAL.Environment.os === 'windows' && MAL.Environment.browser === 'chrome') ||
					(MAL.Environment.browser==='safari')
				){
					stageConfig.layerType = 'JS';
				}

				MAL.stage = new MAL.tween.Stage(stageConfig);
				MAL.stage.start();

				// debug settings
				MAL.DEBUG = true;
				MAL.Object.prototype.logging = true;
				MAL.Object.prototype.logEvents = false;
				MAL.Object.prototype.logEventsCollapsed = false;
				MAL.Object.prototype.logEventsNoListeners = false;

				// noisey objects
				MAL.video.Base.prototype.logging = false;
				MAL.video.Advanced.prototype.logging = false;
				MAL.tween.Layer.prototype.logging = false;
				MAL.tween.Stage.prototype.logging = false;
				MAL.Preloader.prototype.logging = false;
				MAL.services.MouseHotSpot.prototype.logging = false;


				// safari-specific performance hacks
				if (MAL.Environment.browser === 'safari') {
					MAL.Environment.features.perspectivePerformanceFix = false;
					MAL.Environment.features.backfacePerformanceFix = false;
					MAL.Environment.features.translateZPerformanceFix = false;
				}

				var desktopMinimumBrowserCheck = function() {
					// Check if minimum desktop browser requirements are set.
					var browsers = {
						'safari' : 7,
						'firefox' : 35,
						'chrome' : 36,
						'msie' :  9
					};

					return (((MAL.Environment.os === 'windows' && !navigator.userAgent.match('Tablet')) || MAL.Environment.os === 'mac') && browsers[MAL.Environment.browser] && MAL.Environment.browserVersion >= browsers[MAL.Environment.browser]);
				};


				if (desktopMinimumBrowserCheck()) {
					// load the standard rich media experience
					MAL.ad = new MAL.controllers.RichMedia.Main(details);
				} else {
					// TODO: need add static backup in case we need to bail
				}

			}

		});
	}

}

if (!window.MALAdManualReadyCheck) MALAdReadyCheck();