MAL.define('controllers.RichMedia.Main', MAL.controllers.Main.extend({
	initialize: function(config) {
		this._super();

		var self = this;


		// width / height of the window
		this.windowSize = config.windowSize;

		// x / y scroll position of page
		this.pageScroll = config.pageScroll;

		// bounding box of iframe
		this.bannerRect = config.bannerRect;

		// flag to disable events when hidden
		this.isHidden = false;



		// listen to size-update and make any necessary changes here.
		MAL.supertag.addEventListener('size-update', function(object, details) {
			console.log('size update', details);
			if (details.change === 'width') {
				if (details.current === 699) {
					self.isHidden = true;
					setTimeout(function() {

						// hide ad unit and reset page styles
						MAL.supertag.connection.sendMessageToPub({
							'addDirectStyles': {
								'mal-ad-wrapper': {
									'display': 'none'
								},
								'#mal-outer-wrapper': {
									'margin-bottom': '0px'
								},
								'#mal-upper-wrapper': {
									'transform': 'translateY(0)',
									'-webkit-transform': 'translateY(0)',
								},
								'#mal-lower-wrapper': {
									'margin-top': '0px',
									'transform': 'translateY(0)',
									'-webkit-transform': 'translateY(0)',
								}
							}
						});		
					}, 100);
					MAL.rmv.dispatchEvent('hide');
				}

				if (details.current === 'max') {
					self.isHidden = false;
					setTimeout(function() {

						// show ad unit and reset page styles
						MAL.supertag.connection.sendMessageToPub({
							'addDirectStyles': {
								'mal-ad-wrapper': {
									'display': 'block'
								},
								'#mal-outer-wrapper': {
									'margin-bottom': '-120px'
								},
								'#mal-lower-wrapper': {
									'margin-top': '-150px'
								}
							}
						});	
					}, 100);
					MAL.rmv.dispatchEvent('devicesize', 'large');
				}
			}
				
		});


		// instantiate all controllers (this is the only one for now)
		this.controllers.push(this);


		// cache references to elements (refer to views.RichMedia.Main)
		this.ui = {
			frames: this.view.queryLayer('#frames'),
			frame: this.view.queryLayer('#frame'),
			supers: this.view.queryLayer('#supers'),
			super1: this.view.queryLayer('#super-1'),
			super2: this.view.queryLayer('#super-2'),
			loader: this.view.queryLayer('#loader'),
			spinner: this.view.queryLayer('#spinner'),
			overlay: this.view.queryLayer('#overlay')
		};



		// max / min settings for mapped properties

		this.smallWindowHeight = 700;
		this.mediumWindowHeight = 1000;

		this.minWidth = 680;
		this.maxWidth = 1300;
		this.currentWidth = 1300;

		this.currentOffset = 0;

		this.maxScale = MAL.placement.dimensions.width / this.maxWidth;
		this.currentScale = (this.windowSize.width < MAL.placement.dimensions.width) ? this.windowSize.width / this.maxWidth : this.maxScale;
		this.minSuperScale = 0.7

		this.currentScroll = this.bannerRect.top / this.windowSize.height;

		this.minHeight = 115;
		this.maxHeight = 265;
		this.currentHeight = this.minHeight;

		this.prevFrame;
		this.prevFrames = [];
		this.currentFrame = 0;
		this.minFrame = 0;
		this.maxFrame = 199;

		this.minOpacity = 0;
		this.maxOpacity = 1;
		this.currentOpacity1 = this.minOpacity;
		this.currentOpacity2 = this.minOpacity;

		this.minTranslate = 0;
		this.maxTranslate = this.minHeight - this.maxHeight;
		this.currentTranslate = this.minTranslate;


		// scroll ranges - refer to MAL.services.ScrollRange for details

		// main ranges where laptop opens and closes
		this.openingRange = new MAL.services.ScrollRange();
		this.closingRange = new MAL.services.ScrollRange();

		// used to translate page content upwards
		this.translateRange = this.openingRange;

		// ranges for showing / hiding supers
		this.showSuper1Range = new MAL.services.ScrollRange();
		this.hideSuper1Range = new MAL.services.ScrollRange();
		this.showSuper2Range = new MAL.services.ScrollRange();
		this.hideSuper2Range = new MAL.services.ScrollRange();

		// range where clickthrough is active
		this.clickableRange = new MAL.services.ScrollRange();


		// hard-coded height values for each frame
		this.frames = [
			115,
			115,
			115,
			115,
			116,
			116,
			116,
			116,
			116,
			116,
			116,
			116,
			117,
			117,
			118,
			118,
			119,
			119,
			119,
			119,
			119,
			120,
			120,
			121,
			121,
			122,
			122,
			123,
			123,
			124,
			124,
			125,
			125,
			126,
			127,
			127,
			128,
			129,
			130,
			130,
			131,
			132,
			133,
			134,
			134,
			135,
			136,
			137,
			137,
			138,
			139,
			140,
			141,
			141,
			142,
			143,
			144,
			145,
			146,
			147,
			148,
			149,
			150,
			151,
			152,
			153,
			154,
			155,
			156,
			157,
			158,
			159,
			160,
			161,
			162,
			163,
			164,
			165,
			166,
			167,
			168,
			169,
			170,
			171,
			172,
			174,
			175,
			176,
			177,
			179,
			180,
			181,
			182,
			183,
			184,
			185,
			186,
			188,
			189,
			190,
			191,
			192,
			193,
			195,
			196,
			197,
			198,
			199,
			200,
			201,
			202,
			203,
			204,
			206,
			207,
			208,
			209,
			210,
			211,
			212,
			213,
			214,
			215,
			216,
			218,
			219,
			220,
			221,
			222,
			223,
			224,
			225,
			226,
			227,
			228,
			229,
			231,
			232,
			232,
			233,
			234,
			235,
			236,
			236,
			237,
			238,
			239,
			240,
			241,
			242,
			243,
			244,
			244,
			245,
			246,
			247,
			247,
			248,
			249,
			250,
			251,
			252,
			252,
			253,
			253,
			254,
			255,
			256,
			256,
			257,
			258,
			258,
			259,
			260,
			260,
			260,
			261,
			261,
			261,
			261,
			262,
			262,
			262,
			262,
			263,
			263,
			263,
			263,
			264,
			264,
			264,
			264,
			264,
			265,
			265,
			265,
			265,
			265,
			265,
			265
		];


		// kick things off by loading assets
		this._loadImages();
	},

	_updateRanges: function() {
		if (this.windowSize.height < this.smallWindowHeight) {
			this._setSmallRanges();
		} else if (this.windowSize.height < this.mediumWindowHeight) {
			this._setMediumRanges();
		} else {
			this._setLargeRanges();
		}
	},


	_setSmallRanges: function() {
		
		this.openingRange.top = 0.10;
		this.openingRange.bottom = 0.80;

		this.closingRange.disable();

		this.translateRange.top = this.openingRange.top;
		this.translateRange.bottom = this.openingRange.bottom;

		
		this.showSuper1Range.disable();
		this.hideSuper1Range.disable();
		
		this.showSuper2Range.top = 0.10;
		this.showSuper2Range.bottom = 0.40;
		
		this.hideSuper2Range.disable();


		this.clickableRange.top = -0.20;
		this.clickableRange.bottom = 0.20;
	},

	_setMediumRanges: function() {
		
		this.openingRange.top = 0.75 - this.pixelsToPercentage(this.maxHeight * this.currentScale);
		this.openingRange.bottom = 1.00 - this.pixelsToPercentage(this.minHeight * this.currentScale);

		this.closingRange.top = 0.00;
		this.closingRange.bottom = 0.25;

		this.translateRange.top = this.openingRange.top;
		this.translateRange.bottom = this.openingRange.bottom;

		
		this.showSuper1Range.top = 0.60;
		this.showSuper1Range.bottom = 0.65;

		this.hideSuper1Range.top = 0.35;
		this.hideSuper1Range.bottom = 0.40;
		
		this.showSuper2Range.top = 0.30;
		this.showSuper2Range.bottom = 0.35;
		
		this.hideSuper2Range.top = 0.10;
		this.hideSuper2Range.bottom = 0.15;


		this.clickableRange.top = 0.20;
		this.clickableRange.bottom = 0.75 - this.pixelsToPercentage(this.maxHeight * this.currentScale);
	},

	_setLargeRanges: function() {

		this.openingRange.top = 0.70 - this.pixelsToPercentage(this.maxHeight * this.currentScale);
		this.openingRange.bottom = 0.90 - this.pixelsToPercentage(this.minHeight * this.currentScale);

		this.closingRange.top = 0.05;
		this.closingRange.bottom = 0.25;

		this.translateRange.top = this.openingRange.top;
		this.translateRange.bottom = this.openingRange.bottom;

		
		this.showSuper1Range.top = 0.58;
		this.showSuper1Range.bottom = 0.65;

		this.hideSuper1Range.top = 0.40;
		this.hideSuper1Range.bottom = 0.45;
		
		this.showSuper2Range.top = 0.35;
		this.showSuper2Range.bottom = 0.40;
		
		this.hideSuper2Range.top = 0.15;
		this.hideSuper2Range.bottom = 0.20;


		this.clickableRange.top = 0.20;
		this.clickableRange.bottom = 0.70 - this.pixelsToPercentage(this.maxHeight * this.currentScale);
	},




	_loadImages: function() {

		var self = this;

		// add the sprite sheet to the image queue and load it
		self.imageQueue.push('sprites-' + MAL.placement.geo + '.jpg');
		self.imageLoader.load(this.imageQueue);

		// listen for images to finish loading...
		MAL.Util.addEvent(this.imageLoader, 'loaded', function() {
			MAL.rmv.dispatchEvent('load');
			self.dispatchEvent('dom-ready');
			MAL.log('controllers.RichMedia.Main 	|	images finished loading');

			// ... and continue the setup process
			setTimeout(function() {
				self._setup();
			}, 100);

		});

		// listen for images failing to complete loading in time
		MAL.Util.addEvent(this.imageLoader, 'timeout', function() {
			MAL.log('controllers.RichMedia.Main 	|	image loading timed out');
			// TODO: add static fallback scenario
		});
	},



	_setup: function() {
		this._hideLoader();

		this._updateScroll();
		this._updateScale();

		this._updateFrame();
		this._updateHeight();
		this._updateTranslate();
		this._updateSprite();
		this._updateLoader();
		this._updateOverlay();

		this._addListeners();
		this._render();
	},

	pixelsToPercentage: function(pixels) {
		return pixels / this.windowSize.height;
	},

	percentageToPixels: function(percentage) {
		return percentage * this.windowSize.height;
	},



	_updateScroll: function() {
		// calculate top of banner as percentage of window height
		this.currentScroll = this.bannerRect.top / this.windowSize.height;
	},

	_updateScale: function() {
		// called whenever the window is resized
		// updates all properties whose values are dependent on window size or banner scale

		this.currentScale = (this.windowSize.width < MAL.placement.dimensions.width) ? this.windowSize.width / this.maxWidth : this.maxScale;
		this.currentWidth = this.maxWidth;
		this.currentOffset = Math.floor(this.maxHeight * (1 - this.currentScale) * -0.5);

		this._updateRanges();

		this.ui.frames.setProperties({
			'scale': this.currentScale,
			'transform-origin': '0 0 0'
		});
		this.ui.supers.setProperties({
			'scale': (this.currentScale < this.minSuperScale) ? this.minSuperScale : this.currentScale,
			'transform-origin': '0 0 0',
			'margin-left': (this.currentScale < this.minSuperScale) ? (((this.maxWidth * this.currentScale) - (this.maxWidth * this.minSuperScale)) / 2) + 'px' : '0px',
			'margin-top': (this.currentScale < this.minSuperScale) ? (((this.maxHeight * this.currentScale) - (this.maxHeight * this.minSuperScale)) / 2) + 'px' : '0px'
		});

		this._updateLoader();
		this._updateOverlay();

		MAL.supertag.connection.sendMessageToPub({
			'addCustomStyles': {
				'width': (this.currentWidth * this.currentScale) + 'px'
			}
		});

		this._updateFrame(true);
	},


	_addListeners: function() {

		// listen to resize and scroll
		MAL.supertag.connection.addPageListener('window', 'resize', this._onResize);
		MAL.supertag.connection.addPageListener('window', 'scroll', this._onScroll);

		// standard clickthrough (see base controller)
		MAL.Util.addEvent(this.view.element, 'click', this._clickThrough);
	},


	// handler for resize event
	_onResize: function(event) {

		if (this.isHidden) return;

		this.windowSize.width = event.innerWidth;
		this.windowSize.height = event.innerHeight;

		this.bannerRect = event.rect;

		this._updateScroll();
		this._updateScale();
	},

	// handler for scroll event
	_onScroll: function(event) {

		if (this.isHidden) return;

		this.pageScroll.x = event.scrollX;
		this.pageScroll.y = event.scrollY;

		this.bannerRect = event.rect;

		this._updateScroll();
	},


	// render loop using requestAnimationFrame
	// note that renders will only happen when required
	_render: function() {

		this._updateFrame();
		this._updateSuper1();
		this._updateSuper2();

		requestAnimationFrame(this._render);
	},



	_updateFrame: function(force) {

		var prevFrame = this.currentFrame;

		
		if (this.openingRange.isInRange(this.currentScroll)) {

			// opening
			this.currentFrame = Math.ceil(this.openingRange.map(this.currentScroll, this.maxFrame, this.minFrame));

		} else if (this.closingRange.isInRange(this.currentScroll)) {

			// closing
			this.currentFrame = Math.ceil(this.closingRange.map(this.currentScroll, this.minFrame, this.maxFrame));

		} else {

			if (this.currentScroll > this.closingRange.bottom && this.currentScroll < this.openingRange.top) {

				// open (middle of page)
				this.currentFrame = this.maxFrame;

			} else if (this.currentScroll > this.openingRange.bottom || this.currentScroll < this.closingRange.top) {

				// closed (top or bottom of page)
				this.currentFrame = this.minFrame;

			}
		}


		if (this.currentFrame !== prevFrame || force == true) {

			this.prevFrame = prevFrame;

			this._updateHeight();
			this._updateSprite();
			this._updateTranslate();
			this._doEffect();
		}
	},


	_updateHeight: function() {
		// lookup frames hash to find height value corresponding to current frame index
		this.currentHeight = this.frames[this.currentFrame];
	},

	_updateSprite: function() {
		// set the image that is displayed by changing background-position of the frame element
		var row = Math.floor(this.currentFrame / 10)
		var column = this.currentFrame % 10;
		this.ui.frame.setProperty('background-position', (this.maxWidth * column * -1) + 'px ' + (this.maxHeight * row * -1) + 'px');
	},

	_updateTranslate: function() {

		if (this.translateRange.isInRange(this.currentScroll)) {

			// opening
			this.currentTranslate = Math.floor((this.minHeight - this.currentHeight) * this.currentScale);

		} else if (this.currentScroll + this.pixelsToPercentage(this.currentHeight * this.currentScale) > this.translateRange.bottom) {

			// closed (bottom of page)
			this.currentTranslate = this.minTranslate;

		} else if (this.currentScroll < this.translateRange.top) {

			// open (top of page)
			this.currentTranslate = Math.floor(this.maxTranslate * this.currentScale);

		}
	},

	_doEffect: function() {
		// gives the impression of the ad unit expanding by translating the page content above whilst offsetting page content below

		var delta = Math.ceil((this.currentHeight - this.minHeight) * this.currentScale);

		MAL.supertag.message({
			'addDirectStyles': {
				'#mal-upper-wrapper': {
					'transform': 'translate3d(0, ' + this.currentTranslate + 'px, 0)',
					'-webkit-transform': 'translate3d(0, ' + this.currentTranslate + 'px, 0)'
				},
				'#mal-lower-wrapper': {
					'transform': 'translate3d(0, ' + delta + 'px, 0)',
					'-webkit-transform': 'translate3d(0, ' + delta + 'px, 0)',
					'margin-top': (this.currentOffset - 150) + 'px'
				}
			}
		});

	},


	_updateSuper1: function() {

		if (this.showSuper1Range.isInRange(this.currentScroll)) {

			// showing
			this.currentOpacity1 = this.showSuper1Range.map(this.currentScroll, this.maxOpacity, this.minOpacity);

		} else if (this.hideSuper1Range.isInRange(this.currentScroll)) {

			// hiding
			this.currentOpacity1 = this.hideSuper1Range.map(this.currentScroll, this.minOpacity, this.maxOpacity);

		} else {
			if (this.currentScroll < this.hideSuper1Range.top || this.currentScroll > this.showSuper1Range.bottom) {

				// hidden
				this.currentOpacity1 = this.minOpacity;

			} else if (this.currentScroll > this.hideSuper1Range.bottom && this.currentScroll < this.showSuper1Range.top) {

				// shown
				this.currentOpacity1 = this.maxOpacity;

			}
		}

		this.ui.super1.setProperties({
			'opacity': this.currentOpacity1
		});
	},

	_updateSuper2: function() {

		if (this.showSuper2Range.isInRange(this.currentScroll)) {

			// showing
			this.currentOpacity2 = this.showSuper2Range.map(this.currentScroll, this.maxOpacity, this.minOpacity);

		} else if (this.hideSuper2Range.isInRange(this.currentScroll)) {

			// hiding
			this.currentOpacity2 = this.hideSuper2Range.map(this.currentScroll, this.minOpacity, this.maxOpacity);

		} else {
			if (this.currentScroll < this.hideSuper2Range.top || this.currentScroll > this.showSuper2Range.bottom) {

				// hidden
				this.currentOpacity2 = this.minOpacity;

			} else if (this.currentScroll > this.hideSuper2Range.bottom && this.currentScroll < this.showSuper2Range.top) {

				// shown
				this.currentOpacity2 = this.maxOpacity;

			}
		}

		this.ui.super2.setProperties({
			'opacity': this.currentOpacity2
		});

		// Safari hack: Had to set the 'top' style property directly instead of the library's 'setProperty' method
		this.ui.supers.element.style.top = (((this.maxHeight - this.currentHeight + 12) * this.currentScale) / -1.8) + 'px';
	},



	_hideLoader: function() {
		this.isLoaded = true;
		this.ui.spinner.setProperty('display', 'none');
		this.ui.loader.addTween({
			duration: 0.24,
			finish: {
				opacity: 0
			},
			callback: function(layer) {
				layer.setProperties({
					display: 'none'
				});
			}
		});
	},

	_updateLoader: function() {
		// sets the dimensions of the loader

		if (this.isLoaded) return;

		this.ui.loader.setProperties({
			'width': (this.currentWidth * this.currentScale) + 'px',
			'height': (this.currentHeight * this.currentScale) + 'px',
			'transform-origin': '0 0 0'
		});
	},

	_updateOverlay: function() {
		// sets the dimensions of the clickable overlay

		this.ui.overlay.setProperties({
			'width': (this.currentWidth * this.currentScale) + 'px',
			'height': (this.currentHeight * this.currentScale) + 'px',
			'display': (this.clickableRange.isInRange(this.currentScroll)) ? 'block' : 'none',
			'transform-origin': '0 0 0'
		});
	},


	// NOT CURRENTLY USED
	// method of decoding multiple spritesheets sequentially during the loading process
	/*_decodeImages: function() {
		
		var self = this;

		var timer = setInterval(function() {

			if (self.currentSheet <= self.numSheets) {
				self.ui.decoder.setProperty('background-image', 'url(images/' + MAL.placement.backgroundColor + '/sprites-' + self.currentSheet + '.jpg)');
				self.currentSheet++;
			} else {
				clearInterval(timer);
				setTimeout(function() {
					self._hideLoader();
				}, 1000);
			}

		}, 100);
	},*/

}));