/*global MALPaths,MAL,MALChangeset*/
var MALRMVChina =function () {

	// impression pixels %time%
	var trackingURLs = {
        'yhp': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackimp/N4517.275756.YOUKU/B8233801.110756152;dc_trk_aid=283873126;dc_trk_cid=59094777;ord=',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackimp/N4517.275756.YOUKU/B8233801.110752426;dc_trk_aid=283873126;dc_trk_cid=59094777;ord='
        },
		'yom': {
			Detroit: 'http://ad.doubleclick.net/ddm/trackimp/N4517.275756.YOUKU/B8233801.110752435;dc_trk_aid=283873126;dc_trk_cid=59094777;ord=',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackimp/N4517.275756.YOUKU/B8233801.110752427;dc_trk_aid=283873126;dc_trk_cid=59094777;ord='
		},
        'ymu': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackimp/N4517.275756.YOUKU/B8233801.110752432;dc_trk_aid=283873126;dc_trk_cid=59094777;ord=',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackimp/N4517.275756.YOUKU/B8233801.110752424;dc_trk_aid=283873126;dc_trk_cid=59094777;ord='
        },
        'thp': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackimp/N4517.138382.6227534454421/B8233801.110759734;dc_trk_aid=283873126;dc_trk_cid=59094777;ord=',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackimp/N4517.138382.6227534454421/B8233801.110752442;dc_trk_aid=283873126;dc_trk_cid=59094777;ord='
        },
        'tom': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackimp/N4517.138382.6227534454421/B8233801.110752446;dc_trk_aid=283873126;dc_trk_cid=59094777;ord=',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackimp/N4517.138382.6227534454421/B8233801.110752441;dc_trk_aid=283873126;dc_trk_cid=59094777;ord='
        },
        'dhp': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackimp/N4517.149184.DOUBAN/B8233801.110759733;dc_trk_aid=283873126;dc_trk_cid=59094777;ord=',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackimp/N4517.149184.DOUBAN/B8233801.110752437;dc_trk_aid=283873126;dc_trk_cid=59094777;ord='
        },
        'tev': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackimp/N4517.139597.6218904182421/B8233801.110759498;dc_trk_aid=283873126;dc_trk_cid=59094777;ord=',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackimp/N4517.139597.6218904182421/B8233801.110752450;dc_trk_aid=283873126;dc_trk_cid=59094777;ord='
        },
        'ten': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackimp/N4517.139597.6218904182421/B8233801.110752455;dc_trk_aid=283873126;dc_trk_cid=59094777;ord=',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackimp/N4517.139597.6218904182421/B8233801.110752449;dc_trk_aid=283873126;dc_trk_cid=59094777;ord='
        }
	};

	// clickthrough
	var clickthroughs = {
        'yhp': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackclk/N4517.275756.YOUKU/B8233801.110756152;dc_trk_aid=283873126;dc_trk_cid=59094777?',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackclk/N4517.275756.YOUKU/B8233801.110752426;dc_trk_aid=283873126;dc_trk_cid=59094777?'
        },
        'yom': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackclk/N4517.275756.YOUKU/B8233801.110752435;dc_trk_aid=283873126;dc_trk_cid=59094777?',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackclk/N4517.275756.YOUKU/B8233801.110752427;dc_trk_aid=283873126;dc_trk_cid=59094777?'
        },
        'ymu': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackclk/N4517.275756.YOUKU/B8233801.110752432;dc_trk_aid=283873126;dc_trk_cid=59094777?',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackclk/N4517.275756.YOUKU/B8233801.110752424;dc_trk_aid=283873126;dc_trk_cid=59094777?'
        },
        'thp': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackclk/N4517.138382.6227534454421/B8233801.110759734;dc_trk_aid=283873126;dc_trk_cid=59094777?',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackclk/N4517.138382.6227534454421/B8233801.110752442;dc_trk_aid=283873126;dc_trk_cid=59094777?'
        },
        'tom': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackclk/N4517.138382.6227534454421/B8233801.110752446;dc_trk_aid=283873126;dc_trk_cid=59094777?',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackclk/N4517.138382.6227534454421/B8233801.110752441;dc_trk_aid=283873126;dc_trk_cid=59094777?'
        },
        'dhp': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackclk/N4517.149184.DOUBAN/B8233801.110759733;dc_trk_aid=283873126;dc_trk_cid=59094777?',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackclk/N4517.149184.DOUBAN/B8233801.110752437;dc_trk_aid=283873126;dc_trk_cid=59094777?'
        },
        'tev': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackclk/N4517.139597.6218904182421/B8233801.110759498;dc_trk_aid=283873126;dc_trk_cid=59094777?',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackclk/N4517.139597.6218904182421/B8233801.110752450;dc_trk_aid=283873126;dc_trk_cid=59094777?'
        },
        'ten': {
            Detroit: 'http://ad.doubleclick.net/ddm/trackclk/N4517.139597.6218904182421/B8233801.110752455;dc_trk_aid=283873126;dc_trk_cid=59094777?',
            YaoBand: 'http://ad.doubleclick.net/ddm/trackclk/N4517.139597.6218904182421/B8233801.110752449;dc_trk_aid=283873126;dc_trk_cid=59094777?'
        }
	};

    // click for sound tracking
    var soundTracking = {
        'yhp': {
            Detroit: 'http://count.atm.youku.com/c?id=5159',
            YaoBand: 'http://count.atm.youku.com/c?id=5160'
        },
        'yom': {
            Detroit: 'http://count.atm.youku.com/c?id=5161',
            YaoBand: 'http://count.atm.youku.com/c?id=5162'
        },
        'ymu': {
            Detroit: 'http://count.atm.youku.com/c?id=5163',
            YaoBand: 'http://count.atm.youku.com/c?id=5164'
        },
        'thp': {
            Detroit: 'http://count.atm.youku.com/c?id=5165',
            YaoBand: 'http://count.atm.youku.com/c?id=5166'
        },
        'tom': {
            Detroit: 'http://count.atm.youku.com/c?id=5167',
            YaoBand: 'http://count.atm.youku.com/c?id=5168'
        },
        'dhp': {
            Detroit: 'http://erebor.douban.com/redirect/?ad=100196&amp;uid=4237275&amp;bid=brAcKpVVAhU&amp;unit=dale_anonymous_homepage_top_for_crazy_ad&amp;ip=124.205.66.195&amp;crtr=3%3A%2F%3Fp%3D2&amp;mark=&amp;hn=roper4&amp;sig=76aa17f073505788b888581154ef6a9082d840023c22194c7ca7b09b073b4b766e695b31676af4e22c1a1a64e15bfec25cd5ced4cb25292278b9efb604b8350d',
            YaoBand: 'http://erebor.douban.com/redirect/?ad=99658&amp;uid=4237275&amp;bid=brAcKpVVAhU&amp;unit=dale_anonymous_homepage_top_for_crazy_ad&amp;ip=124.205.66.195&amp;crtr=3%3A%2F%3Fp%3D2&amp;mark=&amp;hn=roper4&amp;sig=76aa17f073505788b888581154ef6a9082d840023c22194c7ca7b09b073b4b766e695b31676af4e22c1a1a64e15bfec25cd5ced4cb25292278b9efb604b8350d'
        },
        'tev': {
            Detroit: 'http://sambaclk.adsame.com/c?z=samba&la=0&si=14&ci=2810&c=4134&or=4011&l=4584&bg=4498&b=4561&u=',
            YaoBand: 'http://sambaclk.adsame.com/c?z=samba&la=0&si=14&ci=2810&c=4134&or=4011&l=4586&bg=4500&b=4563&u='
        },
        'ten': {
            Detroit: 'http://sambaclk.adsame.com/c?z=samba&la=0&si=14&ci=2810&c=4135&or=4011&l=4585&bg=4499&b=4562&u=',
            YaoBand: 'http://sambaclk.adsame.com/c?z=samba&la=0&si=14&ci=2810&c=4135&or=4011&l=4587&bg=4501&b=4564&u='
        }
    };

	MAL.define('rmv', new MAL.services.MarcomProxy({

		videoPercentage: 0,
		cached: false,
		staticReason: false,
		clickedForSound: false,

		paths: {
			images: window.MALPaths ? MALPaths.images : './',
			videos: window.MALPaths ? MALPaths.videos : './',
			scripts: window.MALPaths ? MALPaths.scripts : './'
		},

		isRMVReady: function () {
			return true;
		},

		filePathProxy: function (filepath, filename) {
			// every file request goes through this method, this is where you would add additional filepath logic
			return filepath + filename;
		},

		bwNames : [[0,'0-0.5m'],[512,'0.5-1m'],[1000,'1-2m'],[2000,'2-3m'],[3000,'3-4m'],[4000,'4-5m'],[5000,'5-6m'],[6000,'6-7m'],[7000,'7-8m'],[8000,'8-9m'],[9000,'9-10m'],[10000,'10m']],

		baseUrl : {
			Detroit: [[0,'http://www.apple.com/' + MAL.placement.geo + '/your-verse/organizing-a-movement/?cid=wwa-'+ MAL.placement.geo +'-disp-ipad-yv-dbc-']],
			YaoBand: [[0,'http://www.apple.com/' + MAL.placement.geo + '/your-verse/striking-a-new-chord/?cid=wwa-'+ MAL.placement.geo +'-disp-ipad-yv-yb-']]
		},

		getBandwidthNumber: function () {
			var self = this;

			return this.bwNames.reduce(function (p,c) {
				return (self.bandwidth >= c[0]) ? c[0] : p;
			},this.bwNames[0][0]);
		},

		getBandwidthString: function () {
			var self = this;

			return this.bwNames.reduce(function (p,c) {
				return (self.bandwidth >= c[0]) ? c[1] : p;
			},this.bwNames[0][1]);

		},

		getBaseUrl: function () {
			var self = this;

			return this.baseUrl[window.MALCreative].reduce(function (p,c) {
				return (self.bandwidth >= c[0]) ? c[1] : p;
			},this.baseUrl[window.MALCreative][0][1]);

		},

		events : {

			onInit: {
				unique: true,
				handler: function (o) {
					// add init tracking
					MAL.Util.log('RMV:','init');

					// Doubleclick impression tracking
					if(!MAL.isUndefined(trackingURLs[MAL.placement.siteCode])){
						var img = new Image();
						img.src = trackingURLs[MAL.placement.siteCode][window.MALCreative] + new Date().getTime()+'?';
					}
				}
			},

			onCapped: function () {
				this.staticReason = 'capped';

				// add capped tracking
				MAL.Util.log('RMV:','capped');
			},

			onVideoLoadingBar: function () {
				// add show loading bar tracking
				MAL.Util.log('RMV:','showingloadingbar');
			},

			onVideoAutoPlay: function () {
				//add video auto play tracking
				MAL.Util.log('RMV:','autoplay');
			},

			onVideoLoadingPlay: function () {
				// add video loading play tracking
				MAL.Util.log('RMV:','videoloadingplay');
			},

			onVideoEnded: function () {
				// add video ended tracking
				MAL.Util.log('RMV:','videoended');
			},

			onStatic: function (obj) {
				this.staticReason = obj.reason;

				// add static tracking
				MAL.Util.log('RMV:', 'static');
			},

			onClickForSound: function () {
				this.clickedForSound = true;

				// Add click for sound tracking
				MAL.Util.log('RMV:','clickforsound');


                // Doubleclick impression tracking
                if(!MAL.isUndefined(soundTracking[MAL.placement.siteCode])){
                    var img = new Image();
                    img.src = soundTracking[MAL.placement.siteCode][window.MALCreative];
                }
			},

			onClickthrough: function () {
				// get correct clickthrough

				var clickPrepend = '';
				if(!MAL.isUndefined(clickthroughs[MAL.placement.siteCode])){
					clickPrepend = clickthroughs[MAL.placement.siteCode][window.MALCreative];
				}

				var url = clickPrepend + this.getBaseUrl() + MAL.placement.siteCode;
				var creativeType = 'v';

				if (this.staticReason === 'browser') {
					window.open(url + '-dsps');
					MAL.Util.log('RMV: Clickthrough Static');
					return;
				} else if (this.staticReason === 'speed') {
					creativeType = 's';
				} else if (this.staticReason === 'capped') {
					creativeType = 'c';
				}

				if (!this.cached) {
					url += '-nb' + this.getBandwidthString() + '-c0-dsp' + creativeType;
				} else {
					url += '-nb' + this.getBandwidthString() + '-c1-dsp' + creativeType;
				}

				var label = 'clickthrough-' + this.getBandwidthString() + ((this.cached) ? '-cache' : '-nocache') + ((this.clickedForSound) ? '-sound' : '-nosound');
				MAL.Util.log('RMV:', label);

				window.open( url, 'new');

			},

			onBandwidth: {
				unique: true,
				handler: function (o) {
					o.bandwidth += 400;

					this.bandwidth = Math.floor(o.bandwidth);

					if (MAL.Environment.hasLocalStorage) {
						if (localStorage.getItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode)) {
							this.cached = true;
							this.bandwidth = parseInt(localStorage.getItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode),0);

							// add cached bandwidth tracking here
							MAL.Util.log('RMV:','bw-cache-' + this.getBandwidthString());

						} else {
							localStorage.setItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode,this.bandwidth);

							// add none cached bandwidth tracking here
							MAL.Util.log('RMV:','bw-nocache-' + this.getBandwidthString());
						}

					}


				}
			}
		}
	}));
};

var MALRMV = MALRMVChina;