/*global MALPaths,MAL,MALChangeset,studio*/
var MALRMVDoubleClick = function () {

	var clickURLS = {
		us: '',
		cafr: 'ca/fr/',
		caen: 'ca/',
		uk: 'uk/',
		fr: 'fr/'
	};


	var geoCid = {
		us: 'us',
		cafr: 'ca',
		caen: 'ca',
		uk: 'uk',
		fr: 'fr'
	};

	var creativeCodes = {
		Detroit: 'dbc',
		YaoBand: 'yb'
	};

	// Only trigger pixel when geo and creative is the same as browser geo and creative.
	function trackPixel(creative, geo, url, onload ){

		var lowerCreative = '';
		lowerCreative += window.MALCreative || '';
		lowerCreative = lowerCreative.toLowerCase();

		if( !MAL.isUndefined( MAL.placement.geo ) ){
			if( geo === MAL.placement.geo && lowerCreative === creative ){
				var img = document.createElement('img');
				img.src = url;
				if(typeof onload === 'function'){
					img.onload = onload;
				}
			}
		}

	}

	MAL.define('rmv', new MAL.services.MarcomProxy({

		videoPercentage: 0,
		cached: false,
		staticReason: false,
		clickedForSound: false,

		paths: {
			images: window.MALPaths ? MALPaths.images : './',
			videos: window.MALPaths ? MALPaths.videos : './',
			scripts: window.MALPaths ? MALPaths.scripts : './'
		},
		isRMVReady: function () {
			return Enabler.isInitialized();
		},

		filePathProxy: function (filepath, filename) {
			// every file request goes through this method, this is where you would add additional filepath logic
			if(filename.indexOf("mp4") > 0 || filename.indexOf("webm") > 0){
				MAL.log('filePathProxy - ' + filename + " -> " + Enabler.getFilename(filename));
				return Enabler.getFilename(filename);
			}
			return filepath + filename; //+ '?random=' + Date.now();
		},

		bwNames : [[0,'0-0.5m'],[512,'0.5-1m'],[1000,'1-2m'],[2000,'2-3m'],[3000,'3-4m'],[4000,'4-5m'],[5000,'5-6m'],[6000,'6-7m'],[7000,'7-8m'],[8000,'8-9m'],[9000,'9-10m'],[10000,'10m']],

		baseUrl : {
			MightyZeus: [[0, 'http://www.apple.com/macbook/?cid=wwa-' + MAL.placement.geo + '-disp-mac-div-']]
		},

		getBandwidthNumber: function () {
			var self = this;

			return this.bwNames.reduce(function (p,c) {
				return (self.bandwidth >= c[0]) ? c[0] : p;
			},this.bwNames[0][0]);
		},

		getBandwidthString: function () {
			var self = this;

			return this.bwNames.reduce(function (p,c) {
				return (self.bandwidth >= c[0]) ? c[1] : p;
			},this.bwNames[0][1]);

		},

		getBaseUrl: function () {
			var self = this;

			return this.baseUrl[window.MALCreative].reduce(function (p,c) {
				return (self.bandwidth >= c[0]) ? c[1] : p;
			}, this.baseUrl[window.MALCreative][0][1] );

		},

		events : {

			onInit: {
				unique: true,
				handler: function (o) {
					this.creativeVersion = o.video;
					MAL.Util.log('RMV: Init');
					Enabler.counter('Init');

					// only when geo is uk
					trackPixel('detroit', 'uk', 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=19&mc=imp&pli=10703748&PluID=0&ord=' + new Date().getTime() + '&rtu=-1');
					trackPixel('detroit', 'fr', 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=19&mc=imp&pli=10715183&PluID=0&ord=' + new Date().getTime() + '&rtu=-1');
					trackPixel('yaoband', 'uk', 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=19&mc=imp&pli=10703747&PluID=0&ord=' + new Date().getTime() + '&rtu=-1');
					trackPixel('yaoband', 'fr', 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=19&mc=imp&pli=10715182&PluID=0&ord=' + new Date().getTime() + '&rtu=-1');
				}
			},

			onCapped: function () {
				this.staticReason = 'capped';
				MAL.Util.log('RMV: Capped Experience');
				Enabler.counter('Capped Experience');
			},

			onVideoLoadingBar: function () {
				MAL.Util.log('RMV: Showing Loading Bar');
				Enabler.counter('Showing Loading Bar');
			},

			onVideoAutoPlay: function () {
				MAL.Util.log('RMV: Autoplay');
				Enabler.counter('Autoplay');
			},

			onVideoLoadingPlay: function () {
				MAL.Util.log('RMV: Loading Play');
				Enabler.counter('Loading Play');
			},

			onVideoEnded: function () {
				MAL.Util.log('RMV: Video Ended');
				Enabler.counter('Video Ended');
			},

			onStatic: function (obj) {
				this.staticReason = obj.reason;
				MAL.Util.log('RMV: Static',obj.reason);
				Enabler.counter('Static');
			},

			onClickForSound: function () {
				this.clickedForSound = true;
				MAL.Util.log('RMV: Click For Sound');
				Enabler.counter('Click For Sound');
			},

			onClickthrough: function () {
				// Add click tracking here...

				var url = this.getBaseUrl() + creativeCodes[window.MALCreative] + '-' + MAL.placement.siteCode;
				var creativeType = 'v';

				if (this.staticReason === 'browser') {
					MAL.Util.log('RMV: Clickthrough Static');
					Enabler.exitOverride('Clickthrough Static',url + '&dsp=s');
					return;
				} else if (this.staticReason === 'speed') {
					creativeType = 's';
				} else if (this.staticReason === 'capped') {
					creativeType = 'c';
				}

				// this section does not get executed
				// it lists out the custom exit event labels for Studio
				if(1===0){
					Enabler.exit('Clickthrough Static');
					Enabler.exit('Clickthrough With Sound 0-0.5m');
					Enabler.exit('Clickthrough With Sound 0.5-1m');
					Enabler.exit('Clickthrough With Sound 1-2m');
					Enabler.exit('Clickthrough With Sound 2-3m');
					Enabler.exit('Clickthrough With Sound 3-4m');
					Enabler.exit('Clickthrough With Sound 4-5m');
					Enabler.exit('Clickthrough With Sound 5-6m');
					Enabler.exit('Clickthrough With Sound 6-7m');
					Enabler.exit('Clickthrough With Sound 7-8m');
					Enabler.exit('Clickthrough With Sound 8-9m');
					Enabler.exit('Clickthrough With Sound 9-10m');
					Enabler.exit('Clickthrough With Sound 10m');
					Enabler.exit('Clickthrough Without Sound 0-0.5m');
					Enabler.exit('Clickthrough Without Sound 0.5-1m');
					Enabler.exit('Clickthrough Without Sound 1-2m');
					Enabler.exit('Clickthrough Without Sound 2-3m');
					Enabler.exit('Clickthrough Without Sound 3-4m');
					Enabler.exit('Clickthrough Without Sound 4-5m');
					Enabler.exit('Clickthrough Without Sound 5-6m');
					Enabler.exit('Clickthrough Without Sound 6-7m');
					Enabler.exit('Clickthrough Without Sound 7-8m');
					Enabler.exit('Clickthrough Without Sound 8-9m');
					Enabler.exit('Clickthrough Without Sound 9-10m');
					Enabler.exit('Clickthrough Without Sound 10m');
					Enabler.exit('Clickthrough Cached With Sound 0-0.5m');
					Enabler.exit('Clickthrough Cached With Sound 0.5-1m');
					Enabler.exit('Clickthrough Cached With Sound 1-2m');
					Enabler.exit('Clickthrough Cached With Sound 2-3m');
					Enabler.exit('Clickthrough Cached With Sound 3-4m');
					Enabler.exit('Clickthrough Cached With Sound 4-5m');
					Enabler.exit('Clickthrough Cached With Sound 5-6m');
					Enabler.exit('Clickthrough Cached With Sound 6-7m');
					Enabler.exit('Clickthrough Cached With Sound 7-8m');
					Enabler.exit('Clickthrough Cached With Sound 8-9m');
					Enabler.exit('Clickthrough Cached With Sound 9-10m');
					Enabler.exit('Clickthrough Cached With Sound 10m');
					Enabler.exit('Clickthrough Cached Without Sound 0-0.5m');
					Enabler.exit('Clickthrough Cached Without Sound 0.5-1m');
					Enabler.exit('Clickthrough Cached Without Sound 1-2m');
					Enabler.exit('Clickthrough Cached Without Sound 2-3m');
					Enabler.exit('Clickthrough Cached Without Sound 3-4m');
					Enabler.exit('Clickthrough Cached Without Sound 4-5m');
					Enabler.exit('Clickthrough Cached Without Sound 5-6m');
					Enabler.exit('Clickthrough Cached Without Sound 6-7m');
					Enabler.exit('Clickthrough Cached Without Sound 7-8m');
					Enabler.exit('Clickthrough Cached Without Sound 8-9m');
					Enabler.exit('Clickthrough Cached Without Sound 9-10m');
					Enabler.exit('Clickthrough Cached Without Sound 10m');
				}

				// end list of labels
				var studioExitLabel = '';

				if (!this.cached) {
					if (this.clickedForSound) {
						MAL.Util.log('RMV: Clickthrough With Sound',this.bandwidth);
						studioExitLabel = 'Clickthrough With Sound ' + this.getBandwidthString();
					} else {
						MAL.Util.log('RMV: Clickthrough Without Sound',this.bandwidth);
						studioExitLabel = 'Clickthrough Without Sound ' + this.getBandwidthString();
					}

					url += '-nb' + this.getBandwidthString() + '-c0-dsp' + creativeType;
				} else {
					if (this.clickedForSound) {
						MAL.Util.log('RMV: Clickthrough Cached With Sound',this.bandwidth);
						studioExitLabel = 'Clickthrough Cached With Sound ' + this.getBandwidthString();
					} else {
						MAL.Util.log('RMV: Clickthrough Cached Without Sound',this.bandwidth);
						studioExitLabel = 'Clickthrough Cached Without Sound ' + this.getBandwidthString();
					}

					url += '-nb' + this.getBandwidthString() + '-c1-dsp' + creativeType;
				}

				trackPixel('detroit', 'uk', 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=20&mc=click&pli=10703748&PluID=0&ord=' + new Date().getTime() );
				trackPixel('detroit', 'fr', 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=20&mc=click&pli=10715183&PluID=0&ord=' + new Date().getTime() );
				trackPixel('yaoband', 'uk', 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=20&mc=click&pli=10703747&PluID=0&ord=' + new Date().getTime() );
				trackPixel('yaoband', 'fr', 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=20&mc=click&pli=10715182&PluID=0&ord=' + new Date().getTime() );

				Enabler.exitOverride( studioExitLabel, url );
			},

			onBandwidth: {
				unique: true,
				handler: function (o) {
					o.bandwidth += 400;

					this.bandwidth = Math.floor(o.bandwidth);

					// this section does not get executed
					// it lists out the custom exit event labels for Studio
					if(1===0){
						Enabler.counter('Bandwidth 0-0.5m');
						Enabler.counter('Bandwidth 0.5-1m');
						Enabler.counter('Bandwidth 1-2m');
						Enabler.counter('Bandwidth 2-3m');
						Enabler.counter('Bandwidth 3-4m');
						Enabler.counter('Bandwidth 4-5m');
						Enabler.counter('Bandwidth 5-6m');
						Enabler.counter('Bandwidth 6-7m');
						Enabler.counter('Bandwidth 7-8m');
						Enabler.counter('Bandwidth 8-9m');
						Enabler.counter('Bandwidth 9-10m');
						Enabler.counter('Bandwidth 10m');
						Enabler.counter('Bandwidth Cached 0-0.5m');
						Enabler.counter('Bandwidth Cached 0.5-1m');
						Enabler.counter('Bandwidth Cached 1-2m');
						Enabler.counter('Bandwidth Cached 2-3m');
						Enabler.counter('Bandwidth Cached 3-4m');
						Enabler.counter('Bandwidth Cached 4-5m');
						Enabler.counter('Bandwidth Cached 5-6m');
						Enabler.counter('Bandwidth Cached 6-7m');
						Enabler.counter('Bandwidth Cached 7-8m');
						Enabler.counter('Bandwidth Cached 8-9m');
						Enabler.counter('Bandwidth Cached 9-10m');
						Enabler.counter('Bandwidth Cached 10m');
					}

					if (MAL.Environment.hasLocalStorage) {
						if (localStorage.getItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode)) {
							this.cached = true;
							this.bandwidth = parseInt(localStorage.getItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode),0);
							MAL.Util.log('RMV: Bandwidth Cached',this.bandwidth);
							Enabler.counter('Bandwidth Cached ' + this.getBandwidthString());
						} else {
							try {
								localStorage.setItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode,this.bandwidth);
								MAL.Util.log('RMV: BandWidth',this.bandwidth);
								Enabler.counter('Bandwidth ' + this.getBandwidthString());
							} catch (e) {
								return false;
							}
						}
					}
				}
			}
		}
	}));
};

var MALRMV = MALRMVDoubleClick,MALCreative=false;
function onEnablerInit(){
	window.MALCreative = (Enabler.getParameter('video') == null) ? 'Detroit' : Enabler.getParameter('video');
}
if (Enabler.isInitialized()){
	onEnablerInit();
} else {
	Enabler.addEventListener(studio.events.StudioEvent.INIT, onEnablerInit);
}
