/*global MALPaths,MAL,MALChangeset,ad_fpad*/
var MALRMVYahoo = function () {

	var clickURLS = {
		us: '',
		cafr: 'ca/fr/',
		caen: 'ca/'
	};

	var creativeCodes = {
		MightyZeus: 'mz'
	};
	
	MAL.define('rmv', new MAL.services.MarcomProxy({
		
		videoPercentage: 0,
		cached: false,
		staticReason: false,
		clickedForSound: false,

		paths: {
			images: window.MALPaths ? MALPaths.images : './',
			videos: window.MALPaths ? MALPaths.videos : './',
			scripts: window.MALPaths ? MALPaths.scripts : './'
		},

		isRMVReady: function () {
			// add code to check if your tracking is ready
			return (window.ad_fpad);
		},

		filePathProxy: function (filepath, filename) {
			// every file request goes through this method, this is where you would add additional filepath logic
			return filepath + filename; // + '?random=' + Date.now();
		},

		bwNames : [[0,'0-0.5m'],[512,'0.5-1m'],[1000,'1-2m'],[2000,'2-3m'],[3000,'3-4m'],[4000,'4-5m'],[5000,'5-6m'],[6000,'6-7m'],[7000,'7-8m'],[8000,'8-9m'],[9000,'9-10m'],[10000,'10m']],

		baseUrl : {
			MightyZeus: [[0, 'http://www.apple.com/macbook/?cid=wwa-' + MAL.placement.geo + '-disp-mac-div-']]
		},

		getBandwidthNumber: function () {
			var self = this;
			
			return this.bwNames.reduce(function (p,c) {		
				return (self.bandwidth >= c[0]) ? c[0] : p;
			},this.bwNames[0][0]);
		},

		getBandwidthString: function () {
			var self = this;

			return this.bwNames.reduce(function (p,c) {		
				return (self.bandwidth >= c[0]) ? c[1] : p;
			},this.bwNames[0][1]);

		},

		getBaseUrl: function () {
			var self = this;

			return this.baseUrl[window.MALCreative].reduce(function (p,c) {
				return (self.bandwidth >= c[0]) ? c[1] : p;
			},this.baseUrl[window.MALCreative][0][1]);

		},

		events : {

			onInit: {
				unique: true,
				handler: function (o) {					
					this.creativeVersion = o.video;
					MAL.Util.log('RMV: Init');
					ad_fpad.tt('init');

				}
			},

			onCapped: function () {
				MAL.Util.log('RMV: Capped Experience');
				this.staticReason = 'capped';
				ad_fpad.tt('capped');				
			},

			onVideoLoadingBar: function () {
				MAL.Util.log('RMV: Showing Loading Bar');
				ad_fpad.tt('showloadingbar');				
			},

			onVideoAutoPlay: function () {
				MAL.Util.log('RMV: Autoplay');
				ad_fpad.tt('autoplay');				
			},

			onVideoLoadingPlay: function () {
				MAL.Util.log('RMV: Loading Play');
				ad_fpad.tt('loadingplay');				
			},

			onVideoEnded: function () {
				MAL.Util.log('RMV: Video Ended');
				ad_fpad.tt('videoended');				
			},

			onStatic: function () {
				MAL.Util.log('RMV: Static');				
				ad_fpad.tt('static');				
			},

			onClickForSound: function () {
				this.clickedForSound = true;
				ad_fpad.tt('clickforsound');
			},

			onClickthrough: function () {
				// Add click tracking here...
				
				var url = this.getBaseUrl() + creativeCodes[window.MALCreative] + '-' + MAL.placement.siteCode;

				if (this.staticReason === 'browser') {
					ad_fpad.jp('clickthrough-static',url);
					MAL.Util.log('RMV: Clickthrough',this.bandwidth);
					return;
				}

				url += '-nb' + this.getBandwidthString();

				var label = 'clickthrough-' + this.getBandwidthString() + ((this.clickedForSound) ? '-sound' : '-nosound');
				MAL.Util.log('RMV: ',label);
				ad_fpad.jp(label,url);

			},

			onBandwidth: {
				unique: true,
				handler: function (o) {

					MAL.log('BANDWIDTH',o.bandwidth);
					o.bandwidth += 400;

					this.bandwidth = Math.floor(o.bandwidth);

					MAL.log('Actual bandwidth:',this.bandwidth);

					if (MAL.Environment.hasLocalStorage) {
						
						if (localStorage.getItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode)) {
							this.cached = true;
							this.bandwidth = parseInt(localStorage.getItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode),0);
							MAL.Util.log('RMV: Bandwidth Cached',this.bandwidth);
							ad_fpad.tt('bandwidth-cached-' + this.getBandwidthString());
						} else {
							try {
								localStorage.setItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode,this.bandwidth);
								MAL.Util.log('RMV: BandWidth',this.bandwidth);
								ad_fpad.tt('bandwidth-' + this.getBandwidthString());
							} catch (e) {
								return false;
							}
						}

					}

					
				}
			}
		}
		

	}));
};

var MALRMV = MALRMVYahoo;