/*global MALPaths,MAL,MALChangeset,par*/
var MALRMVYahooSports = function () {


    MAL.define('rmv', new MAL.services.MarcomProxy({

        videoPercentage: 0,
        cached: false,
        staticReason: false,
        clickedForSound: false,

        paths: {
            images: window.MALPaths ? MALPaths.images : './',
            videos: window.MALPaths ? MALPaths.videos : './',
            scripts: window.MALPaths ? MALPaths.scripts : './'
        },

        isRMVReady: function () {
            return (window.par);
        },

        filePathProxy: function (filepath, filename) {
            return filepath + filename; // + '?random=' + Date.now();
        },

        bwNames : [[0,'0-0.5m'],[512,'0.5-1m'],[1000,'1-2m'],[2000,'2-3m'],[3000,'3-4m'],[4000,'4-5m'],[5000,'5-6m'],[6000,'6-7m'],[7000,'7-8m'],[8000,'8-9m'],[9000,'9-10m'],[10000,'10m']],

        baseUrl : {
            MightyZeus: [[0, 'http://www.apple.com/macbook/?cid=wwa-' + MAL.placement.geo + '-disp-mac-div-']]
        },

        getBandwidthNumber: function () {
            var self = this;

            return this.bwNames.reduce(function (p, c) {
                return (self.bandwidth >= c[0]) ? c[0] : p;
            }, this.bwNames[0][0]);
        },

        getBandwidthString: function () {
            var self = this;

            return this.bwNames.reduce(function (p, c) {
                return (self.bandwidth >= c[0]) ? c[1] : p;
            }, this.bwNames[0][1]);

        },

        getBaseUrl: function () {
            var self = this;

            return this.baseUrl[window.MALCreative].reduce(function (p, c) {
                return (self.bandwidth >= c[0]) ? c[1] : p;
            }, this.baseUrl[window.MALCreative][0][1]);

        },

        supportsLocalStorage: function() {
            try {
                return 'localStorage' in window && window['localStorage'] !== null;
            } catch (e) {
                return false;
            }
        },

        events: {

            onInit: {
                unique: true,
                handler: function (o) {
                    this.creativeVersion = o.video;
                    MAL.Util.log('RMV: Init');
                    par.adx_track_event('init');
                }
            },

            onCapped: function () {
                MAL.Util.log('RMV: Capped Experience');
                this.staticReason = 'capped';
                par.adx_track_event('capped');
            },

            onVideoLoadingBar: function () {
                MAL.Util.log('RMV: Showing Loading Bar');
                par.adx_track_event('videoloadingbar');
            },

            onVideoAutoPlay: function () {
                MAL.Util.log('RMV: Autoplay');
                par.adx_track_event('autoplay');
            },

            onVideoLoadingPlay: function () {
                MAL.Util.log('RMV: Loading Play');
                par.adx_track_event('loadingplay');
            },

            onVideoEnded: function () {
                MAL.Util.log('RMV: Video Ended');
                par.adx_track_event('videoended');
            },

            onStatic: function (obj) {
                MAL.Util.log('RMV: Static', obj.reason);
                this.staticReason = obj.reason;
                par.adx_track_event('static');
            },

            onClickForSound: function () {
                MAL.Util.log('RMV: Click For Sound');
                this.clickedForSound = true;
                par.adx_track_event('clickforsound');
            },

            onClickthrough: function () {

                var url = this.getBaseUrl() + MAL.placement.siteCode;
                var creativeType = 'v';

                if (this.staticReason === 'browser') {
                    par.adx_click_event(('clickthrough-static'), (url + '-dsps'));
                    MAL.Util.log('RMV: Clickthrough Static');
                    return;
                } else if (this.staticReason === 'speed') {
                    creativeType = 's';
                } else if (this.staticReason === 'capped') {
                    creativeType = 'c';
                }

                if (!this.cached) {
                    url += '-nb' + this.getBandwidthString() + '-c0-dsp' + creativeType;
                } else {
                    url += '-nb' + this.getBandwidthString() + '-c1-dsp' + creativeType;
                }
                
                var label = 'clickthrough-' + this.getBandwidthString() + ((this.cached) ? '-cache' : '-nocache') + ((this.clickedForSound) ? '-sound' : '-nosound');
                MAL.Util.log('RMV: ',label);
                par.adx_click_event(label, url);
            },

            onBandwidth: {
                unique: true,
                handler: function (o) {

                    MAL.log('BANDWIDTH', o.bandwidth);
                    o.bandwidth += 400;

                    this.bandwidth = Math.floor(o.bandwidth);

                    if (MAL.Environment.hasLocalStorage) {

                        if (localStorage.getItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode)) {
                            this.cached = true;
                            this.bandwidth = parseInt(localStorage.getItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode), 0);
                            par.adx_track_event('bandwidth-cached-' + this.getBandwidthString());
                        } else {
                            try {
                                localStorage.setItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode, this.bandwidth);
                                MAL.Util.log('RMV: BandWidth ' + this.getBandwidthString());                                    
                                par.adx_track_event('bandwidth-' + this.getBandwidthString());    
                            } catch (e) {
                                return false;
                            }
                            
                        }

                    }


                }
            }
        }
    }));
};
var MALRMV = MALRMVYahooSports;