MAL.define('services.FrequencyCap', MAL.Object.extend({

	initialize: function($config){
		$config = $config || {};
		this._super();

		this._capAmount = $config.amount || 0;
		this._placementName = "MAL." + $config.placement + "." || "MAL.";

	},

	check: function() {

		if (this._capAmount === 0) return false;

		var date = new Date(),
			dateString = date.getFullYear().toString() + (date.getMonth() + 1).toString() + date.getDate().toString(),
			storageKey = this._placementName + dateString + '.views', // eg MAL.20121214.views
			views;

		if (MAL.Environment.hasLocalStorage) {
			views = localStorage.getItem(storageKey);			
			localStorage.setItem(storageKey, views === null ? 1 : ++views);
			
			if (views > this._capAmount) {
				return true;
			}
		}

		return false;
	}

}));