MAL.define('services.ImageLoader', MAL.Object.extend({

	initialize: function($config) {
		this._super();

		var defaultOptions = {
			maxTime: 5,
			startTime: null,
			manualLoad: false
		};

		$config = MAL.mergeOptions(defaultOptions, $config || {});

		this._maxTime = $config.maxTime;
		this._startTime = $config.startTime;
		this._manualLoad = $config.manualLoad;

		this._timeout = null;
		this._hasTimedOut = false;
	},

	load: function() {
		var self = this,
			controllersSets = (arguments.length > 1) ? MAL.argumentsToArray(arguments) : (arguments.length === 1) ? [arguments[0]] : null;

		this._timeout = setTimeout(this._timedout, this._maxTime * 1000);
		MAL.Async.serial(
			controllersSets.map(function(controllerSet) {
				return function(callback) {
					if (self._hasTimedOut || self._checkTimedOut()) {
						return self.dispatchEvent('timeout');
					}
					if (self._manualLoad) {
						self._loadManualImages(controllerSet, callback);
					} else {
						self._loadControllers(controllerSet, callback);
					}

				};
			}),
			function() {
				if (!self._hasTimedOut) self.dispatchEvent('loaded');
				else self.dispatchEvent('timeout');
			}
		);
	},

	_loadControllers: function(controllers, callback) {
		var images = controllers.map(function(controller) {
			return controller.view.getImages();
		});
		this._preloadImages(images, callback);
	},

	_loadManualImages: function(imagelist, callback) {
		var images = imagelist;
		this._preloadImages(images, callback);
	},

	_timedout: function() {
		this._hasTimedOut = true;
	},

	_checkTimedOut: function() {
		return Date.now() - this._startTime > this._maxTime * 1000;
	},

	_preloadImages: function(images, callback) {
		var preloader = new MAL.Preloader({
			images: images
		});
		preloader.addEventListener('load', callback, false);
		preloader.load();
	}
}));