MAL.define('services.InViewService', MAL.Object.extend({

	initialize: function($config){
		this._super();

		var defaultOptions = {
			width: 0,
			height: 0,
			top: 0,
			left: 0
		};

		$config = MAL.mergeOptions(defaultOptions, $config || {});

		this._width = $config.width;
		this._height = $config.height;
		this._top = $config.top;
		this._left = $config.left;
		this._windowSize = this._getWindowSize();
		this._windowLocation = this._getScrollLocation();
		this._visible = this.focus = this._checkInFullView();
		this._focussed = true;
		this.hidden = null;
		this._setupWindowEvents();

		this._setCheckForVisibility();
	},

	_setCheckForVisibility: function(){
		this.hidden = this._addVisibilityListener(function(hidden){
			var eventObject =  {
				visible: this._checkInFullView(),
				focused: hidden
			};
			MAL.log(eventObject);
			this.hidden = hidden;
			this.dispatchEvent('in-view', eventObject);
		}.bind(this));
	},

	_setupWindowEvents: function() {
		MAL.addEvents(window, {
			scroll: function () {
				this._windowLocation = this._getScrollLocation();

				// dispatch event when scrolled back into view
				if(this._visible !== this._checkInFullView()) {
					var inFullView = this._checkInFullView(),
					str = '';

					switch(inFullView){
						case true: str = 'in'; break;
						case 'partial': str = 'in partial'; break;
						case false: str = 'not in'; break;
					}
					MAL.log('InViewService: ' + str + ' view (focussed)');
					this.dispatchEvent('in-view', {visible: inFullView});
				}

				this._visible = this._checkInFullView();

			}.bind(this),

			resize: function () {
				this._windowSize = this._getWindowSize();
			}.bind(this)
		});
	},

	_getScrollLocation: function () {
		var scrollY = (window.pageYOffset !== undefined) ? window.pageYOffset : (document.documentElement || document.body.parentNode || document.body).scrollTop;
		var scrollX = (window.pageXOffset !== undefined) ? window.pageXOffset : (document.documentElement || document.body.parentNode || document.body).scrollLeft;

		return {x:scrollX,y:scrollY};
	},

	_getWindowSize: function () {
		var size = {};
		if(!window.innerWidth){
			if(document.documentElement.clientWidth !== 0){
				//strict mode
				size.width = document.documentElement.clientWidth;
				size.height = document.documentElement.clientHeight;
			} else {
				//quirks mode
				size.width = document.body.clientWidth;
				size.height = document.body.clientHeight;
			}
		} else {
			size.width = window.innerWidth;
			size.height = window.innerHeight;
		}

		return size;
	},

	_checkInFullView: function () {
		var inFullView = this._top >= this._windowLocation.y && (this._top + this._height) <= this._windowSize.height;

		if(!inFullView && this._windowLocation.y < (this._top + this._height)){
			inFullView = 'partial';
		}

		this.focus = inFullView;

		return inFullView;
	},

	_addVisibilityListener: function (callback) {
		var propertyName = MAL.isUndefined(document.hidden) ? MAL.Environment.engine + 'Hidden' : 'hidden',
			eventName = MAL.isUndefined(document.hidden) ? MAL.Environment.engine + 'visibilitychange' : 'visibilitychange';

		/*document.addEventListener(eventName, function () {
			callback(document[propertyName]);
		});*/

		if (document.addEventListener) {
			document.addEventListener(eventName, function () {
				callback(document[propertyName]);
			}); 
		} else if (document.attachEvent) {
			document.attachEvent(eventName, function () {
				callback(document[propertyName]);
			});
		}

		return document[propertyName];
	}

}));