MAL.define('services.MarcomProxy', MAL.Object.extend({
	initialize: function (RMV) {
		this._super();

		this.startTime = new Date().getTime();
		this.userDetails = MAL.Environment.os+'_'+MAL.Environment.browser+'_'+MAL.Environment.browserVersion;
		var _scope = this;
		this.RMV = RMV;
		this.RMVReady = false;
		this.queue = [];
		this.uniqueEvents = [];

		// copy some stuff to this object
		this.paths = RMV.paths;
		this.filePathProxy = RMV.filePathProxy;
		this.siteAnimations = RMV.siteAnimations || false;
	
		var self = this;		
		if (RMV.events) {
			MAL.each(RMV.events,function (value, key, ref) {				
				var shortName = key.slice(2).toLowerCase();
				self.addEventListener(shortName, function(o,e,c) {
					if (!self.RMVReady) {
						self.queue.push({eventKey:key,eventArgs:c});
						return;
					}

					self.runEventCall(key,c);
				}.bind(self), true);
			});
		} else {
			MAL.log('RMV does not implement any events');
		}

		this.RMVReadyCheck();
	},

	runEventCall: function (eventKey, args) {
		
		if (this.RMV.events[eventKey].unique && this.uniqueEvents.indexOf(eventKey) !== -1) return;

		if (this.RMV.events[eventKey].unique) {
			this.uniqueEvents.push(eventKey);
		}

		if (MAL.ad && MAL.isFunction(MAL.ad.site[eventKey])) {
			MAL.ad.site[eventKey].call(this.RMV,args);
		}

		if (MAL.isFunction(this.RMV.events[eventKey])) {
			this.RMV.events[eventKey].call(this.RMV,args);	
		} else if (this.RMV.events[eventKey].handler) {
			this.RMV.events[eventKey].handler.call(this.RMV,args);
		} else {
			this.log('Event does not implement a handler');
		}
		
	},

	RMVReadyCheck: function () {
		if (this.RMV.isRMVReady) {
			if (this.RMV.isRMVReady()) {
				this.RMVReady = true;
				this.queue.forEach(function (value) {
					this.runEventCall(value.eventKey,value.eventArgs);					
				}, this);
			} else {
				setTimeout(this.RMVReadyCheck, 50);
			}
		} else {
			this.RMVReady = true;
		}
	}
}));