/*global MAL*/
MAL.define('services.MouseHotSpot', MAL.Object.extend({
	initialize: function ($config) {
		$config = $config || {};
		this._super();

		this._working = true;

		this._bounds = [];
		this._inBounds = false;
		this._deActivateTimer = null;
		this._activateTimer = null;

		this._mouseObj = {};

		this._deActivateDelay = 0;
		this._activateDelay = 0;

		this._zeroObj = null;

		this._autoDeactivate = false;
		this._active = false;
		this.name = "";
		this._instantActive = false;

		if ($config.bounds) this.addBounds($config.bounds);
		if ($config.zero) this.addZero($config.zero);
		if ($config.deActivateDelay) this.setDeactivateDelay($config.deActivateDelay);
		if ($config.activateDelay) this.setActivateDelay($config.activateDelay);

		MAL.addEvent(window,'mousemove', this._onMouseMove.bind(this));
		MAL.addEvent(window,'click', this._onMouseMove.bind(this));
	},

	setDisabled: function () {
		//MAL.log('DISABLING HOTSPOT');
		this._working = false;
	},

	setEnabled: function() {
		MAL.log('ENABLING HOTSPOT');
		this._working = true;
	},

	isWorking: function() {
		return this._working;
	},

	setDeactivateDelay: function (delay) {
		this._deActivateDelay = delay*1000;
		this._autoDeactivate = true;
	},

	setActivateDelay: function (delay) {
		this._activateDelay = delay;
	},

	addBounds: function (bounds) {

		bounds.x = bounds.x || 0;
		bounds.y = bounds.y || 0;

		this._bounds.push(bounds);


	},

	addZero: function (element) {
		if (typeof element === 'string') {
			this._zeroObj = document.getElementById(element);
		} else {
			this._zeroObj = element;
		}

	},

	_clearTimers: function () {
		clearTimeout(this._activateTimer);
		clearTimeout(this._deActivateTimer);
	},

	_deActivate: function () {

		if (!this._instantActive) return;

		this._instantActive = false;
		this._clearTimers();

		this.dispatchEvent('deactivate');
		this._active = false;
	},


	_activate: function() {


		if (this._instantActive) return;

		this._instantActive = true;

		if (this._autoDeactivate) {
			this._setDeactiveTimer();
		}
		clearTimeout(this._activateTimer);
		this._activateTimer = setTimeout(this._delayedActivate.bind(this), this._activateDelay);

	},

	_currInBounds: function () {
		if (!this._active && !this._instantActive) this._activate();
		this.dispatchEvent('active');

		if (this._autoDeactivate) {
			this._setDeactiveTimer();
		}

	},

	_currOutBounds: function () {
		if (this._active) return;
		this.dispatchEvent('inactive');
	},

	_delayedActivate: function() {

		if (this._active) return;

		this._active = true;
		clearTimeout(this._activateTimer);

		this.dispatchEvent('activate');
	},

	_setDeactiveTimer: function () {
		clearTimeout(this._deActivateTimer);
		this._deActivateTimer = setTimeout(function () {
			this._deActivate();
		}.bind(this), this._deActivateDelay);
	},

	_checkBounds: function (x, y) {
		var inBounds = false,
			cX,
			cY;
		for (var i = 0, l = this._bounds.length; i < l; i++) {

			var bounds = this._bounds[i];


			if (this._zeroObj != null) {
				var zeroPosition = MAL.findElementPosition(this._zeroObj);
				cX = this._bounds[i].x + zeroPosition.x;
				cY = this._bounds[i].y + zeroPosition.y;

			} else {
				cX = this._bounds[i].x;
				cY = this._bounds[i].y;
			}


			if (cX <= x && (cX+bounds.width) >= x && cY <= y && (cY+bounds.height) >= y) inBounds = true;
		}

		if (inBounds) {
			this.dispatchEvent('inbound');
		}
		if ((inBounds && !this._inBounds) || (!this._active && inBounds)) {
			this._currInBounds();

			if (inBounds && !this._inBounds)
				this._activate();

		} else if (inBounds && this._inBounds && this._autoDeactivate) {
			this._setDeactiveTimer();


		} else if (!inBounds && this._instantActive) {
			this._currOutBounds();
			this._deActivate();
			this._clearTimers();
		}



		this._inBounds = inBounds;
	},

	_setMouse: function(x,y) {

		var scrollY = (window.pageYOffset !== undefined) ? window.pageYOffset : (document.documentElement || document.body.parentNode || document.body).scrollTop;


		if (this._zeroObj != null) {

			var zeroPosition = MAL.findElementPosition(this._zeroObj);


			this._mouseObj.x = x - zeroPosition.x;
			this._mouseObj.y = (y - zeroPosition.y) + scrollY;
		} else {
			this._mouseObj.x = x;
			this._mouseObj.y = (y + scrollY);
		}


	},

	getMouse: function() {

		return this._mouseObj;

	},

	_onMouseMove: function (e) {

		if (!this._working) return;

		var scrollY = (window.pageYOffset !== undefined) ? window.pageYOffset : (document.documentElement || document.body.parentNode || document.body).scrollTop;
		var scrollX = (window.pageXOffset !== undefined) ? window.pageXOffset : (document.documentElement || document.body.parentNode || document.body).scrollLeft;

		this._setMouse(e.clientX,e.clientY);
		this._checkBounds((e.clientX+scrollX), (e.clientY+scrollY));
	}
}));