MAL.define('services.ResponsiveRMV', MAL.Object.extend({
	initialize: function($config, connection){
		this.connection = connection;
		this.config = $config;
		this.setup();
		return this;
	},
	setup: function(){
		if (window.addEventListener) {
			window.addEventListener('message', this.connection.receiveMessageFromPub, false); 
		} else if (window.attachEvent) {
			window.attachEvent('message', this.connection.receiveMessageFromPub);
		}

		this.breaks = this.configureBreakPoints(this.config.breaks);

		this.connectionInstance = this.connection.createConnection(this.config.container, this.breaks.sizes, this.config.placementId, this.config.nested);

		this.connection.updateAdSize = this.update;
		this.connection.updatePageScroll = this.updatePageScroll;
		this.connection.setDebugMode(true);

	},

	update: function(size, type){
		if(this.breaks.sizes[type][size] && this.breaks.callbacks[type][this.breaks.sizes[type][size]].length > 0){
			this.breaks.callbacks[type][this.breaks.sizes[type][size]].forEach(function(callback){
				callback();
			});
		}
	},

	updatePageScroll: function(position){
		MAL.log('updated scroll position: '+position);
	},

	configureBreakPoints: function(breaks){
		var sizes = {width: [], height: []};
		var callbacks = {width: {}, height: []};
		var self = this;

		for (var dimension in breaks){
			for (var d in breaks[dimension]){
				d = parseInt(d, 10).toString() !== 'NaN' && typeof parseInt(d, 10) === 'number' ? parseInt(d, 10) : d;
				sizes[dimension].push(d);
				if(breaks[dimension][d].messages){
					callbacks[dimension][d] = callbacks[dimension][d] ? callbacks[dimension][d] : [];

					callbacks[dimension][d].push(function(b){
						return function(){
							if(b.messages)
								self.connection.sendMessageToPub(b.messages);
						};
					}(breaks[dimension][d]));
				}
				if(breaks[dimension][d].callback){
					callbacks[dimension][d] = callbacks[dimension][d] ? callbacks[dimension][d] : [];
					callbacks[dimension][d].push(breaks[dimension][d].callback);
				}
			}
		}

		return {sizes: sizes, callbacks: callbacks};
	},
	/*
	** styles object using css
	 */
	addCustomStyle: function(message){
		this.connection.sendMessageToPub('addDirectStyles: '+JSON.stringify(message));
	}
}));