var MALPitchfork = function () {
	MAL.define('placement', {
		geo: 'uk',

		siteCode: 'pit',

		dimensions: {
			width: 1300,
			height: 265
		},

		showKeyline: false,

		frequencyCap: false,

		backgroundColor: 'white',

		supertag: {
			nested: 0,

			connection: new MAL.connections.Default(),

			// special cases for collapse
			collapse: (MAL.Environment.browser === 'msie' && MAL.Environment.documentMode <=9) || MAL.Environment.browser === 'firefox',
			container: document.getElementById('mal-ad-container'),

			// breakpoints of sizes
			breakpoints: {
				width:{
					680: {
						setAdSize: {
							width: '100%',
							height: '0px',
						},
						/*addCustomStyles: {
							margin: '10px auto',
							float: 'none'
						}*/
					},
					max: {
						setAdSize: {
							width: '1300px',
							height: '265px',
						},
						/*addCustomStyles: {
							margin: '10px auto',
							float: 'none'
						}*/
					}
				}
			}
		}
	});

	MAL.define('Site', MAL.Object.extend({
		initialize: function (ad) {
			this._super();

			this.ad = ad;
			
			// manipulate the custom wrapper elements on the page
			MAL.supertag.message({
				'addDirectStyles': {
					'.mal-content-wrapper': {
						'-webkit-backface-visibility': 'hidden',
						'-webkit-transform': 'translateZ(0)',
						'-webkit-perspective': 1000
					},
					'#mal-upper-outer-wrapper': {
						'overflow': 'hidden',
						'margin-bottom': '-120px'
					},
					'#mal-upper-inner-wrapper': {

					},
					'#mal-lower-outer-wrapper': {
						'overflow': 'hidden'
					},
					'#mal-lower-inner-wrapper': {
						'margin-top': '-150px'
					},
					'#mal-ad-wrapper': {
						'overflow': 'hidden'
					},
					'#page': {
					    'background': '#ffffff'
					}				
				}
			});

			if( MAL.Environment.browser === 'msie' && MAL.Environment.documentMode >= 9 && MAL.Environment.documentMode <= 10 ){
				this.ad._domContainer.style.cssText = 'transform: rotateZ(0deg) translateX(0) translateZ(0) scale(0.999); opacity:0.9999; ';
			}
		},

		onStylesheetReady: function () {
		 	MAL.log('site.js: stylesheet-ready');
		},

		onDOMReady: function () {
		 	MAL.log('site.js: dom-ready');
		}
	}));
};

var MALSite = MALPitchfork;
var MALCreative = 'MightyZeus';