var PromiseObject = require('promise-object'),
	fs = require('fs'),
	exec = require('child_process').exec;

var MarcomEndcard = PromiseObject.create({

	initialize: function ($self, $config, callback) {

		this._currentObj = $config.vendors;

		// type, geo, site
		this._buildArray = [];

		for (var i = 0; i < $config.vendors.length; i++) {
			var obj = $config.vendors[i];
			var currentType = $config.vendors[i].type;

			for (var geoKey in obj.geos ) {

				if ( obj.geos.hasOwnProperty( geoKey ) ) {

					var siteList = obj.geos[geoKey];

					for( var siteKey in siteList )
					{
						if( siteList.hasOwnProperty(siteKey) )
						{
							var tempObject = { type: currentType, geo: geoKey, siteName: '', sourceDir: '', destDir: '' };

							if( typeof siteList[siteKey].name !== 'undefined' )
							{
								tempObject.destDir = geoKey +'_'+ siteList[siteKey].name;
								tempObject.siteName = siteList[siteKey].name;
							} else {
								var siteName = siteKey.split('.');
									siteName = siteName[0] === 'www' ? siteName[1] : siteName[0];

								tempObject.destDir = geoKey +'_'+ siteName;
								tempObject.siteName = siteKey;

							}

							tempObject.sourceDir = siteKey;


							this._buildArray.push( tempObject );
						}
					}
				}
			}
		}

		this._getChangeset().then(function (changeset) {

			var buildNumber = changeset;

			for (var i = 0; i < $self._buildArray.length; i++) {
				var campaignInfo = $self._buildArray[i];

				var sourcePath = 'sites/'+ campaignInfo.geo +'/'+ campaignInfo.sourceDir +'/endcard';
				var destPath = 'output/build_r'+ buildNumber +'/'+ campaignInfo.type +'/'+ campaignInfo.destDir;

				if( fs.existsSync( 'sites/'+ campaignInfo.geo +'/'+ campaignInfo.sourceDir +'/endcard' ) )
				{
					if( fs.existsSync( destPath ) )
					{
						var files = fs.readdirSync( sourcePath );

						console.log( 'Endcard copied for: '+ campaignInfo.siteName );

						for( var j = 0; j < files.length; j++ )
						{
							var file = files[j];
							fs.createReadStream( sourcePath +'/'+ file ).pipe(fs.createWriteStream( destPath +'/'+ file ));
						}
					}
				}
			}


		});
	},

	_getGit: function ($deferred) {

		exec('git rev-list HEAD --count',function (err,stdout,stderr) {
			if (err) throw new Error('Git/Hg Repo not found, use "--r 1" to set the changeset manually');
			$deferred.resolve(parseInt(stdout)-1);
		});
	},

	_getChangeset: function ($deferred,$self) {

		if (this._changeset) return $deferred.resolve(this._changeset);

		$self._getGit().then(function (changeset) {
			$deferred.resolve(changeset);
		});
	}



});


module.exports = function(grunt) {
	grunt.registerTask('marcom-endcard', 'Publishing endcards', function() {
		var callback = this.async(),
			config = grunt.config('marcom');

		new MarcomEndcard( config, callback );

	});
};