MAL.define('connections.Default', MAL.Object.extend({
	initialize: function(){
		return this;
	},

	createConnection: function(element, breakpoints, id, index){
		window.addEventListener('resize', this.resize.bind(this));
		this._adContainer = element;
		this._breakpoints = breakpoints;
		this._id = id;
		this._currentState = {
			width: null,
			height: null
		};

		this.resize();
	},

	resize: function(){
		var data = {
			width: document.body.offsetWidth,
			height: document.body.offsetHeight
		};

		for(var type in this._breakpoints){
			var breakpoints = this._breakpoints[type];
			if(breakpoints.length > 0){
				var state = breakpoints.length;
				var points = breakpoints.forEach(function(breakpoint, index){
					if(data[type] <= breakpoint && index < state){
						state = index;
					}
				});
				if(this.updateAdSize && typeof this._currentState[type] !== 'undefined' && this._currentState[type] !== state){
					this._currentState[type] = state;
					this.updateAdSize(state, type);
				}
			}
		}

	},

	setDebugMode: function(mode){
		if(mode === true || mode === false){
			MAL.connections.Default.prototype.logging = mode;
		}
	},

	sendMessageToPub: function(message){
		for (var type in message){
			if(this[type]){
				this[type](message[type]);
			}
		}
	},

	addPageListener: function(target, type, callback){
		var targetName = null;
		if(typeof target === 'string' && window[target]){
			targetName = target;
			target = window[target];
		} else if (typeof target === 'string'){
			targetName = target;
			target = document.querySelector(target);
		} else {
			try{
				targetName = target.toString().match(/^\[object (.+)\]$/)[1].toLowerCase();
			} catch(e){
				MAL.log('Target doesnt exist.');
				return;
			}
		}
		window.addEventListener('custom' + targetName + type, callback, false);
		target.addEventListener(type, this.customEvent.bind(this), false);
	},

	customEvent: function(event){
		var _event = {};
		var _element;
		var _target;
		var _type;
		var _rect = {};

		for(var key in event){
			_event[key] = event[key];
		}

		if(_event['currentTarget']['window']){
			_element = window;
			_target = 'window';
		} else if(_event['currentTarget']['write']){
			_element = document;
			_target = 'document';
		} else{
			_element = document.getElementById(_event.target.id);
			_target = _event.target.id;
		}

		_type = _event['type'];
		_event['currentTarget'] = null;
		_event['srcElement'] = null;
		_event['target'] = null;
		_event['toElement'] = null;
		_event['view'] = null;

		switch(_type){
			case 'resize':
				_event['innerWidth'] = window.innerWidth;
				_event['innerHeight'] = window.innerHeight;
			break;

			case 'scroll':
				_event['scrollX'] = _element.scrollX;
				_event['scrollY'] = _element.scrollY;
			break;
		}

		try{
			for(var key in this._adContainer.getBoundingClientRect()){
				_rect[key] = this._adContainer.getBoundingClientRect()[key];
			}

			_event['rect'] = _rect;
		}catch(error){
			MAL.log(this._id, 'getBoundingClientRect is not supported by this browser');
		}

		try{

			var _custom_event = document.createEvent('Event');
 			_custom_event.initEvent('custom' + _target + _type, true, false);

			for(var key in _event){
				_custom_event[key] = _event[key];
			}

			window.dispatchEvent(_custom_event);
		}catch(error){
			MAL.error(this._id, 'cyclic structure found in listener event object, cannot send event to ad');
			MAL.log(this._id, _custom_event);
		}
	},

	setAdSize: function(message){
		for(var property in message){
			if (property.match(/width|height/)){
				this._adContainer.style[property] = message[property];
			}
		}
	},

	addCustomStyles: function(message){
		for(var key in message){
			this._adContainer.style[key] = message[key];
		}
	},

	addDirectStyles: function(object){
		for(var key in object){
			MAL.toArray(document.querySelectorAll(key)).forEach(function(element){
				for(var property in object[key]){
					element.style[property] = object[key][property];
				}
			});
		}
	},

	getPubPageInfo: function(){
		var rect = this._adContainer.getBoundingClientRect();
		var info = {
			window: {height: window.innerHeight, width: window.innerWidth},
			body: {width: document.body.offsetWidth, height: document.body.offsetHeight},
			scroll: {x: window.pageXOffset || document.documentElement.scrollLeft, y: window.pageYOffset || document.documentElement.scrollTop},
			rect: {
				top: rect.top,
				left: rect.left,
				right: rect.right,
				bottom: rect.bottom,
				width: rect.width,
				height: rect.height
			}
		};

		info.iframe = info.rect || {};

		return info;
	},

	closeAd: function(){
		window.removeEventListener('resize', this.handleResize);
		this._adContainer.parentNode.removeChild(this._adContainer);
	}


}));