var exec = require('child_process').exec,
    Promise = require('bluebird'),
    color = require('colors'),
    PromiseObject = require('promise-object')(Promise);

var Changeset = PromiseObject.create({

    initialize: function ($deferred, $self, $config) {
        
        this._log = [];
        this._revision = $config.revision;
        this.active = {};
        this.tip = {};
        this._error = null;
    },

    _getActiveRevision: function ($self, rev) {
        var active = {};

        this._log.forEach(function (item) {           
            if (item.revision === rev) active = item;
        });

        if (!active.revision) {
            console.log("Warn: No revision with the number ".yellow + rev.toString().yellow + " found. Only revision was returned".yellow);
            active.revision = rev;
            active.branch = "default";
        }

        $self.active = active;
        return active;
    },

    getHistory: function ($self) {        
        return $self._log;
    },

    getData: function ($deferred,$self) {
        
        this._getMercurial().then(function () {
            if ($self._revision) $self._getActiveRevision($self._revision);
            $deferred.resolve();

        },function () {
            $self._getGit().then(function () {
                if ($self._revision) $self._getActiveRevision($self._revision);
                $deferred.resolve();
            }, function (err) {
                if ($self._revision) $self._getActiveRevision($self._revision);
                $deferred.reject(err);
            });
        });
    },

    _getMercurial: function ($deferred, $self) {
        exec('hg identify', function (err, stdout, stderr) {
            if (err) return $deferred.reject(); 
            var currentChangeset = stdout.match(/([0-9a-z]+)/)[1];
            exec('hg branch', function (err, stdout, stderr) {

                var currentBranch = stdout.match(/([0-9a-z]+)/)[1];

                exec('hg log',function (err,stdout,stderr) {
                    // console.log(stdout);
                    var log = stdout.split(/changeset:\s{3}\d+:/ig)
                    log.shift();
                    log.reverse();

                    log.forEach(function (item,i) {
                        // console.log(item);

                        var hash = item.match(/(.*)/);
                        var user = item.match(/user:\s{8}(.*)/);
                        var date = item.match(/date:\s{8}(.*)/);
                        var branch = item.match(/branch:\s{6}(.*)/);
                        var message = item.match(/summary:\s{4}(.*)/);

                        var row = {
                            user: user[1],
                            hash: hash[1],
                            branch: (branch) ? branch[1] : "default",
                            date: new Date(date[1]),
                            message: message[1],
                            revision: i
                        }

                        if (currentChangeset === hash[1]) {
                            row.active = true;
                            $self.active = row;
                            $self.tip = row;
                        }

                        $self._log.push(row);
                        // if (row.branch === currentBranch) console.log(row);
                    });
                    // console.log($self._log);
                    $deferred.resolve();
                });
            });
        });
    }, 

    _getGit: function ($deferred, $self) {
        exec('git rev-list HEAD --reverse --max-count=1', function (err, stdout, strerr) {
            if (err) {
                return $deferred.reject('no repo found');
            }
            
            var currentHead = stdout.match(/[0-9a-z]+/)[0];

            exec('git rev-parse --abbrev-ref HEAD', function (err,stdout, strerr) {

                var branch = stdout.replace('\n','');
            
                exec('git log', {maxBuffer: 1024*1024}, function (err,stdout,stderr) {

                    var log = stdout.split(/\n\ncommit\s/ig);
                    log[0] = log[0].replace(/commit\s([0-9a-z]+\n(Author|Merge))/,"$1");

                    log.reverse();
                    log.forEach(function (item,i) {

                        var hash = item.match(/([0-9a-z]+)/);
                        var user = item.match(/Author:\s(.*)/);
                        var date = item.match(/Date:\s{3}(.*)/);
                        
                        var message = item.replace(/Date:(.*)(.*)\n\s{5}/ig,'||||||||').split('||||||||')[1];

                        var row = {
                            user: user[1],
                            hash: hash[1],
                            branch: branch,
                            date: new Date(date[1]),
                            message: message,
                            revision: i
                        }

                        if (currentHead === hash[1]) {
                            row.active = true;

                            $self.active = row;
                            $self.tip = row;
                        }

                        $self._log.push(row);

                        // console.log(row);
                    })

                    $deferred.resolve();  
                });

            });

        })
    }


});

module.exports = Changeset;