var exec = require('child_process').exec,
	glob = require('glob'),
	when = require('whenplus'),
	PromiseObject = require('promise-object'),
	util = require('util'),
	fs = require('fs'),
	path = require('path'),
	malftp = require('node-transmit'),
	malChangeset = require('node-changeset')


var config = {
	server: {
		host: 'digital.mediaartslab.com',
	}
};

var Stage = PromiseObject.create({
	initialize: function ($self, $config, callback) {
		if(!$config.stage || ($config.stage && !$config.stage.protocol || !$config.stage.host)){
			console.error('You need to specify a proper staging configuration. Please read, then try again: https://github.mediaartslab.com/development/grunt-marcom/blob/master/README.md');
			return;
		}
		this._name = $config.stage.name;
		this._root = $config.stage.root;
		this._directory = $config.stage.directory;
		this._revision = $config.stage.revision;

		this._protocol = $config.stage.protocol;
		this._host = $config.stage.host;

		this._changeset = new malChangeset({revision:$config.overrideRevision});
		this._changeset.getData()
			.then(this._stage)
			.then(callback);

	},

	_stage: function ($deferred, $self) {
		var rootPath = path.join($self._root);
		if($self._directory){
			rootPath = path.join(rootPath, $self._directory);
		}

		$self._revision = 'r'+$self._changeset.active.revision;

		var connection = new malftp({
			protocol: this._protocol,
			host: this._host,
			rootPath: rootPath,
			createRootPath: true,
			ready: function () {
				connection.rmdir($self._revision, true).done(function () {

					var folders = [$self._revision].concat($self._mapPaths(glob.sync('output/'+ $self._changeset.active.branch +'_r' + $self._changeset.active.revision + '/*/'))),
						files = $self._mapPaths(glob.sync('output/'+ $self._changeset.active.branch +'_r' + $self._changeset.active.revision + '/**/*.*'));

					connection.mkdirs(folders).done(function () {
						connection.upload(files).done(function () {
							console.log('wrote ' + files.length + ' files to the server'.green);
							connection.disconnect();
						});
					});
				})
			}
		});
	},

	_mapPaths: function ($self, paths) {
		var regex = new RegExp('output/'+$self._changeset.active.branch+'_r'+$self._changeset.active.revision+'/');
		return paths.map(function (source) {
			return {source: source, dest: path.join($self._revision, source.replace(/\/$/,'').replace(regex,''))};
		});
	}
});

module.exports = function(grunt) {
	grunt.registerTask('marcom-stage', 'Stage marcom project', function() {
		var callback = this.async(),
			config = grunt.config('marcom');
			config.overrideRevision = grunt.option('r');

		new Stage(config, callback);
	});
};