/*global MALPaths,MAL,MALChangeset,prActivity,pr_trk,prup,PRPID,prTrackActivity*/
var MALRMVPointroll =function () {

	var clickURLS = {
		us: '',
		cafr: 'ca/fr/',
		caen: 'ca/'
	};

	var creativeCodes = {
		MightyZeus: 'mz'
	};

	MAL.define('rmv', new MAL.services.MarcomProxy({

		videoPercentage: 0,
		cached: false,
		staticReason: false,
		clickedForSound: false,

		paths: {
			images: window.MALPaths ? MALPaths.images : './images/',
			videos: window.MALPaths ? MALPaths.videos : './videos/',
			scripts: window.MALPaths ? MALPaths.scripts : './'
		},
		isRMVReady: function () {
			return true; //window.prsw && window.prgo;
		},

		filePathProxy: function (filepath, filename) {
			// every file request goes through this method, this is where you would add additional filepath logic
			return filepath + filename;
		},

		bwNames : [[0,'0-0.5m'],[512,'0.5-1m'],[1000,'1-2m'],[2000,'2-3m'],[3000,'3-4m'],[4000,'4-5m'],[5000,'5-6m'],[6000,'6-7m'],[7000,'7-8m'],[8000,'8-9m'],[9000,'9-10m'],[10000,'10m']],

		baseUrl : {
			MightyZeus: [[0,'http://www.apple.com/?']],
		},

		getBandwidthNumber: function () {
			var self = this;

			return this.bwNames.reduce(function (p,c) {
				return (self.bandwidth >= c[0]) ? c[0] : p;
			},this.bwNames[0][0]);
		},

		getBandwidthString: function () {
			var self = this;

			return this.bwNames.reduce(function (p,c) {
				return (self.bandwidth >= c[0]) ? c[1] : p;
			},this.bwNames[0][1]);
		},

		getBaseUrl: function () {
			var self = this;

			/*return this.baseUrl[window.MALCreative].reduce(function (p,c) {
				return (self.bandwidth >= c[0]) ? c[1] : p;
			},this.baseUrl[window.MALCreative][0][1]);*/

			return this.baseUrl[window.MALCreative][0][1];
		},

		events : {

			onInit: {
				unique: true,
				handler: function (o) {
					this.creativeVersion = o.video;
					MAL.Util.log('RMV: Init');
					//prActivity(1);

				}
			},

			onCapped: function () {
				MAL.Util.log('RMV: Capped Experience');
				this.staticReason = 'capped';
				prActivity(2);
			},

			onVideoLoadingBar: function () {
				MAL.Util.log('RMV: Showing Loading Bar');
				prActivity(3);
			},

			onVideoAutoPlay: function () {
				MAL.Util.log('RMV: Autoplay');
				prActivity(4);
			},

			onVideoLoadingPlay: function () {
				MAL.Util.log('RMV: Loading Play');
				prActivity(5);
			},

			onVideoEnded: function () {
				MAL.Util.log('RMV: Video Ended');
				prActivity(6);
			},

			onStatic: function () {
				MAL.Util.log('RMV: Static');
				prActivity(7);
			},

			onClickForSound: function () {
				MAL.Util.log('RMV: Click For Sound');
				this.clickedForSound = true;
				prActivity(8);
			},

			onClickthrough: function () {
				// Add click tracking here...

				MAL.Util.log('RMV: Clickthrough');

				var url = this.getBaseUrl() + creativeCodes[window.MALCreative] + '-' + MAL.placement.siteCode;

				/*var pr_trk = false;
				var prup = false;

				if (this.staticReason === 'browser') {
					window.open(url,'new');
					pr_trk('pc', prup, 5, 1);
					MAL.Util.log('RMV: Clickthrough',this.bandwidth);
					return;
				}

				if (!this.cached) {
					// doing clickthrough tracking with real bandwidth
					if (this.clickedForSound) {
						pr_trk('pc', prup, 1, 1, this.getBandwidthString());
					} else {
						pr_trk('pc', prup, 2, 1, this.getBandwidthString());
					}
				} else {
					// doing clickthrought with cached bandwidth

					if (this.clickedForSound) {
						pr_trk('pc', prup, 3, 1, this.getBandwidthString());
					} else {
						pr_trk('pc', prup, 4, 1, this.getBandwidthString());
					}
				}

				url += '-nb' + this.getBandwidthString();*/
				window.open(url,'new');
			},



			onBandwidth: {
				unique: true,
				handler: function (o) {
					MAL.log('BANDWIDTH',o.bandwidth);
					o.bandwidth += 400;

					this.bandwidth = Math.floor(o.bandwidth);


					if (MAL.Environment.hasLocalStorage) {
						if (localStorage.getItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode)) {
							this.cached = true;
							this.bandwidth = parseInt(localStorage.getItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode),0);
							MAL.Util.log('RMV: Bandwidth Cached',this.bandwidth);
							prTrackActivity(10, PRPID, prup, 0, this.getBandwidthString());
						} else {
							localStorage.setItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode,this.bandwidth);
							MAL.Util.log('RMV: BandWidth',this.bandwidth);
							prTrackActivity(9, PRPID, prup, 0, this.getBandwidthString());
						}

					}


				}
			}
		}


	}));

	if (!MAL.isUndefined(window.MALChangeset)) {
		MAL.rmv.paths = {
			images: 'http://speed.pointroll.com/clients/apple/marcom/2014/supertag/r' + MALChangeset + '/',
			videos: 'http://speed.pointroll.com/clients/apple/marcom/2014/supertag/r' + MALChangeset + '/',
			scripts: 'http://speed.pointroll.com/clients/apple/marcom/2014/supertag/r' + MALChangeset + '/'
		};
	}
};

var MALRMV = MALRMVPointroll;
