/**
 * Copyright 2015, Media Arts Lab
 *
 * USE OF THIS SOFTWARE IS STRICTLY LIMITED TO MEDIA ARTS LAB FOR APPLE WORK
 * AND USE OF THIS SOFTWARE BY ANY OTHER PARTY IS PROHIBITED WITHOUT WRITTEN
 * PERMISSION FROM MEDIA ARTS LAB.
 *
 * changeset 217 built on 08/04/15 "aa" 10:55:00 AM
 *
 *     sites/us/theverge.com/site.js
 */

MALSiteChangeset = '217';

var MALVerge = function () {
	MAL.define('placement', {
		geo: 'us',

		siteCode: 'ver',

		dimensions: {
			width: 1023,
			height: 265
		},

		showKeyline: false,

		frequencyCap: false,

		backgroundColor: 'white',

		supertag: {
			nested: 1,

			connection: new prAdConnection(false),

			// special cases for collapse
			collapse: (MAL.Environment.browser === 'msie' && MAL.Environment.documentMode <=9),

			// breakpoints of sizes
			breakpoints: {
				width:{
					699: {
						setAdSize: {
							width: '100%',
							height: '0px',
						},
						/*addCustomStyles: {
							margin: '10px auto',
							float: 'none'
						}*/
					},
					max: {
						setAdSize: {
							width: '1300px',
							height: '265px',
						},
						/*addCustomStyles: {
							margin: '10px auto',
							float: 'none'
						}*/
					}
				}
			}
		}
	});

	MAL.define('Site', MAL.Object.extend({
		initialize: function (ad) {
			this._super();

			this.ad = ad;

			// manipulate the custom wrapper elements on the page
			MAL.supertag.message({
				'addDirectStyles': {
					'.mal-wrapper': {
						'-webkit-backface-visibility': 'hidden',
						'-webkit-transform': 'translateZ(0)',
						'-webkit-perspective': 1000
					},
					'#mal-outer-wrapper': {
						'overflow': 'hidden',
						'margin-bottom': '-120px'
					},
					'#mal-upper-wrapper': {

					},
					'#mal-lower-wrapper': {
						'margin-top': '-150px'
					},
					'#mal-ad-wrapper': {
						'overflow': 'hidden'
					}
				}
			});

			/*MAL.supertag.message({
				'setAdSize': {
					'width': MAL.placement.dimensions.width + 'px',
					'hegith': '0px'
				}
			});*/
		}

	}));
};

var MALSite = MALVerge;
var MALCreative = 'MightyZeus';