/*global MAL,console*/
/**
 * @author Martijn Korteweg <martijn@mediaartslab.com>
 * @docauthor Martijn Korteweg <martijn@mediaartslab.com>
 *
 * **WARNING: this has yet to be finalized**
 *
 * @class MAL.canvas.Shape
 * @extends MAL.Object
 */
MAL.define('canvas.Shape', MAL.Object.extend({
	/**
	 * initializes MAL.canvas.Shape
	 *
	 * @method constructor
	 * @param {Object} config
	 */
	initialize: function ($options) {
		this._super();

		if (!$options.shape) {
			MAL.error('Error: Shape Is required');
		}

		$options = MAL.mergeOptions({
			shape: [],
			anchor: null
		}, $options);


		this._points = this._identifyLines($options.shape);
		this._zeroShape();

		//this._points = this._transformed = this.transform(this._zero);
		this._position = {x:0,y:0};
		this._anchor = $options.anchor || this._findCenterPoint(this._shape);


	},

	_zeroShape: function () {

		var self = this;
		var points = {
			x: [],
			y: []
		};

		this._points.forEach(function (item) {
			points.x.push(item.point[item.point.length-2]);
			points.y.push(item.point[item.point.length-1]);
		});

		var xMin = MAL.arrayMin(points.x);
		var yMin = MAL.arrayMin(points.y);

		this._points = this._points.map(function(item) {
			var points = item.point;

			for (var i = 0;i<points.length;i+=2) {
				points[i] -= xMin;
				points[i+1] -= yMin;
			}
			return {type:item.type,point:points};
		});

	},

	_identifyLines: function (shape) {

		this._shape = shape.map(function (shape) {
			if (MAL.isObject(shape)) return shape;

			var finalShape = {type:'line',point:shape};

			if (shape.length === 4) finalShape.type = 'quadraticCurve';
			if (shape.length === 6) finalShape.type = 'bezierCurve';

			return finalShape;
		});

		return this._shape;
	},

	_findCenterPoint: function (_points) {

		var points = {
			x: [],
			y: []
		};

		_points.forEach(function (item) {
			points.x.push(item.point[item.point.length-2]);
			points.y.push(item.point[item.point.length-1]);
		});

		var xMin = MAL.arrayMin(points.x), xMax = MAL.arrayMax(points.x);
		var yMin = MAL.arrayMin(points.y), yMax = MAL.arrayMax(points.y);

		return {
			x: xMin+(Math.abs(xMin-xMax)/2),
			y: yMin+(Math.abs(yMin-yMax)/2)
		};
	},

	_getDistance: function(x1, y1, x2, y2) {
		var dx = x1-x2,dy = y1-y2;
		return Math.sqrt( dx * dx + dy * dy );
	},

	_getAngle : function(center, p1) {
		var p0 = {x: center.x, y: center.y - Math.sqrt(Math.abs(p1.x - center.x) * Math.abs(p1.x - center.x) + Math.abs(p1.y - center.y) * Math.abs(p1.y - center.y))};
		return (2 * Math.atan2(p1.y - p0.y, p1.x - p0.x)) * 180 / Math.PI;
	},

	_getRotatedPoint : function(pX,pY,degrees) {
		var rX = this._anchor.x,rY = this._anchor.y;
		var r = this._getDistance(pX,pY,rX,rY);

		var startAngle = this._getAngle({x:rX,y:rY},{x:pX,y:pY});

		degrees += startAngle-90;

		return {
			x: (rX + r * Math.cos(degrees * (Math.PI / 180 ))),
			y: (rY + r * Math.sin(degrees * (Math.PI / 180 )))
		};
	},

	_getScaledPoint : function (pX, pY, scale) {

		var sX = this._anchor.x,sY = this._anchor.y;
		var distanceX = sX+((pX - sX)*scale);
		var distanceY = sY+((pY - sY)*scale);
		return {x:distanceX,y:distanceY};
	},

	_rotate: function (_point,degrees) {
		var self = this;
		_point = _point.map(function(item) {
			var point = [],points = [];

			for (var i = 0;i<item.point.length;i+=2) {
				point = self._getRotatedPoint(item.point[i],item.point[i+1],degrees);
				points[i] = point.x;
				points[i+1] = point.y;
			}
			return {type:item.type,point:points};
		});
		return _point;
	},

	_scale: function (_point,degrees) {
		var self = this;
		_point = _point.map(function(item) {
			var point = [],points = [];

			for (var i = 0;i<item.point.length;i+=2) {
				point = self._getScaledPoint(item.point[i],item.point[i+1],degrees);
				points[i] = point.x;
				points[i+1] = point.y;
			}
			return {type:item.type,point:points};
		});
		return _point;
	},

	_move: function (_points,position) {

		this._transformed = this._transformed.map(function (item) {
			var points = item.point;
			for (var i = 0;i<points.length;i+=2) {
				points[i] += position.x;
				points[i+1] += position.y;
			}
			return {type:item.type,point:points};
		});
	},

	transform: function ($options) {

		this._transformed = this._points;

		if (!$options) return;


		if ($options.scale) this._transformed = this._scale(this._transformed,$options.scale);
		if ($options.rotate) this._transformed = this._rotate(this._transformed,$options.rotate);

		var move = {
			x: $options.x || 0,
			y: $options.y || 0
		};

		if (move.y > 0 || move.x > 0)
			this._move(this._transformed,move);

		return this._transformed;

	},

	getTransformedShape: function () {
		return this._transformed;
	},

	draw: function (ctx) {

		var lines = this._transformed;

		ctx.beginPath();
		ctx.moveTo(lines[0].point[0],lines[0].point[1]);
		for (var i = 1;i<lines.length;i++) {
			switch(lines[i].type) {
				case 'line':
					ctx.lineTo(lines[i].point[0],lines[i].point[1]);
					break;
				case 'move':
					ctx.moveTo(lines[i].point[0],lines[i].point[1]);
					break;
				case 'quadraticCurve':
					ctx.quadraticCurveTo(lines[i].point[0], lines[i].point[1], lines[i].point[2], lines[i].point[3]);
					break;
				case 'bezierCurve':
					ctx.bezierCurveTo(lines[i].point[0], lines[i].point[1], lines[i].point[2], lines[i].point[3],lines[i].point[4], lines[i].point[5]);
					break;
			}
		}
		ctx.closePath();
	}

}));