/**
 * @author Chad Scira <chad@mediaartslab.com>
 * @docauthor Chad Scira <chad@mediaartslab.com>
 *
 * **WARNING: this has yet to be finalized**
 *
 * @class MAL.tween.CSSJSLayer
 * @extends MAL.tween.CSSLayer
 */
MAL.define('tween.CSSJSLayer', MAL.tween.CSSLayer.extend({
	// standard easing dictionary list
	_eases: {
		ease: [0.25, 0.1, 0.25, 1],
		linear: [0, 0, 1, 1],
		'ease-in': [0.42, 0, 1, 1],
		'ease-out': [0, 0, 0.58, 1],
		'ease-in-out': [0.42, 0, 0.58, 1]
	},

	/**
	 * updates the layers cssText based on the current tween thats being applied
	 *
	 * @private
	 * @param {Number} time
	 */
	_update: function (time) {
		if (!this._currentTween) return;

		var tween = this._currentTween,
			finished = time > (tween.startTime + tween.duration),
			percent = (time - tween.startTime) / tween.duration;

		// in case we are late
		if (percent > 1) percent = 1;

		// apply ease if provided
		if (MAL.isArray(tween.easing)) {
			percent = MAL.cubicBezierWithPercent(percent, tween.easing[0], tween.easing[1], tween.easing[2], tween.easing[3]);
		} else {
			percent = tween.easing(percent);
		}

		// apply changes to properties
		for (var property in tween.values.start) {
			var value = MAL.Util.shortenFloat(tween.values.start[property] + (tween.values.delta[property] * percent), 5);
			this.setProperty(property, value, true);
		}

		// apply everything to the DOM
		this._css('transform', this._constructTransformationString());
		this._setCSSTextFromBuffer();

		// check if animation is complete
		if (finished) {
			this._currentTween = null;
			//this._clearTemporaryCachedProperties();

			// fire persistant callback
			if (this._persistantCallback) this._persistantCallback(this);

			// fire callback
			if (tween.callback) tween.callback(this);

			this.dispatchEvent('animation-end');
			this._startNextAnimation();
		}
	},

	/**
	 * constructs and adds an animation to the tween stack, also handles the delay
	 *
	 * @private
	 * @param {Object} options
	 */
	_applyAnimation: function (signature, options) {
		// if signature missmatch, animation has been overridden
		if (signature !== this._signature) return;

		// we don't really need to do it this way but to keep the core logic consistant...
		if (options.delay) {
			this._stage.timeouts.addTimeout((function (self, signature, options) {
				return function () {
					// remove delay
					options.delay = 0;

					// apply animation with start values
					self._applyAnimation.apply(self, [signature, options]);
				};
			}(this, signature, options)), options.delay * 1000);

			return;
		}

		// checks if we have transformation support
		this._transformationSupport = !!MAL.Environment.getCSSPropertyName('transform') && !this._bugs.transformations;

		// force hardware acceleration (webkit is the only browser that supports a Z axis)
		if (MAL.Environment.has3d && !this._bugs.transform3d && this._features.backfacePerformanceFix) this._transformations.translateZ = '0px';

		// set start with props
		if (options.start) this._setStartProperties(options.start);

		// generate deltas
		var tween = {};
		tween.duration = options.duration * 1000 || 1000;
		tween.startTime = new Date().getTime();
		if (options.easing) {
			tween.easing = MAL.isString(options.easing) && this._eases[options.easing] ? this._eases[options.easing] : options.easing;
		} else {
			tween.easing = this._eases.linear;
		}

		tween.values = {
			start: {},
			delta: {},
			finish: options.finish
		};
		tween.callback = options.callback;

		for (var property in options.finish) {
			tween.values.start[property] = MAL.parseNumber(this.getProperty(property));
			tween.values.delta[property] = MAL.delta(tween.values.start[property], options.finish[property]);
		}

		this._currentTween = tween;
		this._animating = true;

		// increment iteration count
		this.iteration++;

		this.dispatchEvent('animation-start');
	}
}));
MAL.tween.CSSJSLayerProxy = new MAL.tween.LayerProxy(MAL.tween.CSSJSLayer);