/**
 * @author Chad Scira <chad@mediaartslab.com>
 * @docauthor Chad Scira <chad@mediaartslab.com>
 *
 * Tween property object.
 *
 * **This type of property object is used in the following methods:**
 *
 * - {@link MAL.tween.JSLayer#addTween}
 * - {@link MAL.tween.JSLayer#addTweenSet}
 * - {@link MAL.tween.JSLayer#addTweenOverride}
 * - {@link MAL.tween.JSLayer#addTweenSetOverride}
 * - {@link MAL.tween.CSSLayer#addTween}
 * - {@link MAL.tween.CSSLayer#addTweenSet}
 * - {@link MAL.tween.CSSLayer#addTweenOverride}
 * - {@link MAL.tween.CSSLayer#addTweenSetOverride}
 *
 * # Tween Object Examples
 * 
 * a basic tween requires a {@link #duration} and a {@link #finish}
 * 
 *      {duration: 1, finish: {x: 100}}
 * 
 * tween with a {@link #delay}
 * 
 *      {delay: 1, duration: 1, finish: {x: 100}}
 *      
 * tween with a {@link #delay} and a {@link #start}
 * 
 *      {delay: 1, duration: 1, start: {visibility: 'visible'}, finish: {x: 100}}
 *
 * tween with some basic {@link #easing}
 *
 *     {duration: 1, finish: {x: 100}, easing: 'ease-out'}
 *
 * tween with custom {@link #easing}
 *
 *     {duration: 1, finish: {x: 100}, easing: [.42, 0, .58, 1]}
 * 
 * @class MAL.tween.TweenObject
 */
 
/**
 * @property {Object} start
 *
 * sets the specified properties immediately after the delay is done.
 *
 * you can pass in css properties or animatable properties
 *
 * **transform properties:**
 *
 *  - {@link MAL.tween.TransformObject#transformOrigin transformOrigin}
 *  - {@link MAL.tween.TransformObject#x x}
 *  - {@link MAL.tween.TransformObject#y y}
 *  - {@link MAL.tween.TransformObject#z z}
 *  - {@link MAL.tween.TransformObject#opacity opacity}
 *  - {@link MAL.tween.TransformObject#rotate rotate}
 *  - {@link MAL.tween.TransformObject#rotateX rotateX}
 *  - {@link MAL.tween.TransformObject#rotateY rotateY}
 *  - {@link MAL.tween.TransformObject#scale scale}
 *  - {@link MAL.tween.TransformObject#scaleX scaleX}
 *  - {@link MAL.tween.TransformObject#scaleY scaleY}
 *  - {@link MAL.tween.TransformObject#scaleZ scaleZ}
 *  - {@link MAL.tween.TransformObject#width width}
 *  - {@link MAL.tween.TransformObject#height height}
 *  - {@link MAL.tween.TransformObject#left left}
 *  - {@link MAL.tween.TransformObject#top top}
 *
 */

/**
 * @property {Object} finish
 *
 * destination properties which are going to be animated upon over the tweens duration.
 *
 * **animatable properties:**
 *
 *  - {@link MAL.tween.TransformObject#x x}
 *  - {@link MAL.tween.TransformObject#y y}
 *  - {@link MAL.tween.TransformObject#z z}
 *  - {@link MAL.tween.TransformObject#opacity opacity}
 *  - {@link MAL.tween.TransformObject#rotate rotate}
 *  - {@link MAL.tween.TransformObject#rotateX rotateX}
 *  - {@link MAL.tween.TransformObject#rotateY rotateY}
 *  - {@link MAL.tween.TransformObject#scale scale}
 *  - {@link MAL.tween.TransformObject#scaleX scaleX}
 *  - {@link MAL.tween.TransformObject#scaleY scaleY}
 *  - {@link MAL.tween.TransformObject#scaleZ scaleZ}
 *  - {@link MAL.tween.TransformObject#width width}
 *  - {@link MAL.tween.TransformObject#height height}
 *  - {@link MAL.tween.TransformObject#left left}
 *  - {@link MAL.tween.TransformObject#top top}
 *
 */

/**
 * @property {Number} delay
 *
 * amount of time in seconds that the tween should wait before it starts animating
 */

/**
 * @property {Number} duration
 *
 * duration of the animation in seconds
 */

/**
 * @property {Array/String} easing
 *
 * cubic Bézier easing, the following are presets and can be used by passing a string instead of a custom array
 * 
 * - **ease** [.25, .1, .25, 1],
 * - **linear** [0, 0, 1, 1]
 * - **ease-in** [.42, 0, 1, 1]
 * - **ease-out** [0, 0, .58, 1]
 * - **ease-in-out** [.42, 0, .58, 1]
 *
 * you can also use the <a target="_blank" href="http://thelab.mediaartslab.com/library/cubics/">curve tool</a> to create custom timing easily
 */