MAL.define('controllers.Main', MAL.ViewController.extend({
	initialize: function(){
		this._super();

		var self = this;

		// rev up to make sure library change gets pushed through
		if (location.search.match(/removecap/)){
			delete localStorage['MALBWTRK'];
		}

		this.startTime = Date.now();

		this.controllers = [];

		this.imageQueue = new Array();
		this.imageLoader = new MAL.services.ImageLoader({maxTime: 10, startTime: this.startTime, manualLoad: true});

		this.responsiveRMV = MAL.responsiveRMV;

		MAL.rmv.dispatchEvent('init', {creative:window.MALCreative});

		this.site = new MAL.Site(this);

		// this is just for demonstration, and will be done in a much cleaner way
		this.stylesheet = new MAL.Stylesheet({
			callback: this._writeMainViewToDomAndLoad.bind(this)
		});

		this.domContainer = document.getElementById('mal-ad-container');


		this._animationFramePolyfill();
	},

	_writeMainViewToDomAndLoad: function () {
		this.stylesheet.addView(this);
		this.stylesheet.writeStyles();

		// attempt to center the loader
		this.ui.loader.setProperties({'width': this.currentWidth * this.currentScale + 'px', 'height': this.maxHeight * this.currentScale / 2 + 'px'});

		this.domContainer.appendChild(this.view.element);

		var self = this;

		this.dispatchEvent('stylesheet-ready');
	},

	_writeViewsToDOM: function () {
		var controllers = MAL.argumentsToArray(arguments);

		// write styles
		this.stylesheet.addViews(controllers);
		this.stylesheet.writeStyles();

		// add views to DOM
		this.view.appendElementsTo(controllers);
	},

	_clickThrough: function () {

		MAL.rmv.dispatchEvent('clickthrough');
	},




	// polyfill for standardizing the requestAnimationFrame API
	// courtesy of paul irish
	_animationFramePolyfill: function() {
		var lastTime = 0;
		var vendors = ['webkit', 'moz'];
		for (var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
		window.requestAnimationFrame = window[vendors[x]+'RequestAnimationFrame'];
			window.cancelAnimationFrame =
			window[vendors[x]+'CancelAnimationFrame'] || window[vendors[x]+'CancelRequestAnimationFrame'];
		}
		if (!window.requestAnimationFrame) {
			window.requestAnimationFrame = function(callback, element) {
				var currTime = new Date().getTime();
				var timeToCall = Math.max(0, 16 - (currTime - lastTime));
				var id = window.setTimeout(function() { callback(currTime + timeToCall); },
				timeToCall);
				lastTime = currTime + timeToCall;
				return id;
			};
		}
		if (!window.cancelAnimationFrame) {
			window.cancelAnimationFrame = function(id) {
				clearTimeout(id);
			};
		}
	}

}));

