/*global MALPaths,MAL,MALChangeset,YAHOOFPAD*/
var MALRMVYahoo = function () {


	var trackingURLs = {
		uk: {

			Detroit: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=19&mc=imp&pli=10693188&PluID=0&ord=%time%&rtu=-1',
			YaoBand: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=19&mc=imp&pli=10692983&PluID=0&ord=%time%&rtu=-1'
		},
		de: {
			Detroit: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=19&mc=imp&pli=10693174&PluID=0&ord=%time%&rtu=-1',
			YaoBand: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=19&mc=imp&pli=10693026&PluID=0&ord=%time%&rtu=-1'
		},
		au: {
			Detroit: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=19&mc=imp&pli=10693164&PluID=0&ord=%time%&rtu=-1',
			YaoBand: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=19&mc=imp&pli=10693117&PluID=0&ord=%time%&rtu=-1'
		},
		fr: {
			Detroit: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=19&mc=imp&pli=10693168&PluID=0&ord=%time%&rtu=-1',
			YaoBand: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=19&mc=imp&pli=10693076&PluID=0&ord=%time%&rtu=-1'
		}
	};

	// clickthrough
	var clickthroughs = {
		uk: {
			Detroit: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=20&mc=click&pli=10693188&PluID=0&ord=%time%',
			YaoBand: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=20&mc=click&pli=10692983&PluID=0&ord=%time%'
		},
		de: {
			Detroit: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=20&mc=click&pli=10693174&PluID=0&ord=%time%',
			YaoBand: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=20&mc=click&pli=10693026&PluID=0&ord=%time%'
		},
		au: {
			Detroit: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=20&mc=click&pli=10693164&PluID=0&ord=%time%',
			YaoBand: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=20&mc=click&pli=10693117&PluID=0&ord=%time%'
		},
		fr: {
			Detroit: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=20&mc=click&pli=10693168&PluID=0&ord=%time%',
			YaoBand: 'https://bs.serving-sys.com/BurstingPipe/adServer.bs?cn=tf&c=20&mc=click&pli=10693076&PluID=0&ord=%time%'
		}
	};


	MAL.define('rmv', new MAL.services.MarcomProxy({

		videoPercentage: 0,
		cached: false,
		staticReason: false,
		clickedForSound: false,

		paths: {
			images: window.MALPaths ? MALPaths.images : './',
			videos: window.MALPaths ? MALPaths.videos : './',
			scripts: window.MALPaths ? MALPaths.scripts : './'
		},

		isRMVReady: function () {
			// add code to check if your tracking is ready
			return (window.YAHOOFPAD);
		},

		filePathProxy: function (filepath, filename) {
			// every file request goes through this method, this is where you would add additional filepath logic
			return filepath + filename; // + '?random=' + Date.now();
		},

		bwNames : [[0,'0-0.5m'],[512,'0.5-1m'],[1000,'1-2m'],[2000,'2-3m'],[3000,'3-4m'],[4000,'4-5m'],[5000,'5-6m'],[6000,'6-7m'],[7000,'7-8m'],[8000,'8-9m'],[9000,'9-10m'],[10000,'10m']],

        baseUrl : {
            Detroit: [[0,'http://www.apple.com/' + MAL.placement.geo + '/your-verse/organizing-a-movement/?cid=wwa-'+ MAL.placement.geo +'-disp-ipad-yv-dbc-']],
            YaoBand: [[0,'http://www.apple.com/' + MAL.placement.geo + '/your-verse/striking-a-new-chord/?cid=wwa-'+ MAL.placement.geo +'-disp-ipad-yv-yb-']]
        },

		getBandwidthNumber: function () {
			var self = this;

			return this.bwNames.reduce(function (p,c) {
				return (self.bandwidth >= c[0]) ? c[0] : p;
			},this.bwNames[0][0]);
		},

		getBandwidthString: function () {
			var self = this;

			return this.bwNames.reduce(function (p,c) {
				return (self.bandwidth >= c[0]) ? c[1] : p;
			},this.bwNames[0][1]);

		},

		getBaseUrl: function () {
			var self = this;

			return this.baseUrl[window.MALCreative].reduce(function (p,c) {
				return (self.bandwidth >= c[0]) ? c[1] : p;
			},this.baseUrl[window.MALCreative][0][1]);

		},

		events : {

			onInit: {
				unique: true,
				handler: function (o) {
					this.creativeVersion = o.video;
					MAL.Util.log('RMV: Init');
					YAHOOFPAD.track('billboard_load_billboard_init');

					// Sizmek impression tracking
					if( !MAL.isUndefined(trackingURLs[MAL.placement.geo]) &&
						!MAL.isUndefined(trackingURLs[MAL.placement.geo][window.MALCreative]))
					{
						var img = new Image();
						var src = trackingURLs[MAL.placement.geo][window.MALCreative].replace('%time%', new Date().getTime() );
						img.src = src;
					}
				}
			},

			onCapped: function () {
				MAL.Util.log('RMV: Capped Experience');
				this.staticReason = 'capped';
				YAHOOFPAD.track('billboard_load_billboard_capped');
			},

			onVideoLoadingBar: function () {
				MAL.Util.log('RMV: Showing Loading Bar');
				YAHOOFPAD.track('billboard_load_billboard_showloadingbar');
			},

			onVideoAutoPlay: function () {
				MAL.Util.log('RMV: Autoplay');
				YAHOOFPAD.track('billboard_view_billboard_autoplay');
			},

			onVideoLoadingPlay: function () {
				MAL.Util.log('RMV: Loading Play');
				YAHOOFPAD.track('billboard_view_billboard_loadingplay');
			},

			onVideoEnded: function () {
				MAL.Util.log('RMV: Video Ended');
				YAHOOFPAD.track('billboard_view_billboard_videoended');
			},

			onStatic: function () {
				MAL.Util.log('RMV: Static');
				YAHOOFPAD.track('billboard_load_billboard_static');
			},

			onClickForSound: function () {
				this.clickedForSound = true;
				YAHOOFPAD.track('billboard_click_billboard_clickforsound');
			},

			onClickthrough: function () {
				// Add click tracking here...

				var url = this.getBaseUrl() + MAL.placement.siteCode;
				var creativeType = 'v';

				if (this.staticReason === 'browser') {
					// window.open(url + '-dsps');
					MAL.Util.log('RMV: Clickthrough',this.bandwidth);
					YAHOOFPAD.track('billboard_click_billboard_clickthroughstatic');
					window.open(url);

					return;
				} else if (this.staticReason === 'speed') {
					creativeType = 's';
				} else if (this.staticReason === 'capped') {
					creativeType = 'c';
				}

				if (!this.cached) {
					url += '-nb' + this.getBandwidthString() + '-c0-dsp' + creativeType;
				} else {
					url += '-nb' + this.getBandwidthString() + '-c1-dsp' + creativeType;
				}

				var label = 'billboard_click_billboard_clickthrough' + this.getBandwidthString() + ((this.cached) ? 'cache' : 'nocache') + ((this.clickedForSound) ? 'sound' : 'nosound');
				MAL.Util.log('RMV: ',label);

				// Sizmek tracking
				if( !MAL.isUndefined(clickthroughs[MAL.placement.geo]) &&
					!MAL.isUndefined(clickthroughs[MAL.placement.geo][window.MALCreative]))
				{
					var img = new Image();
					var src = clickthroughs[MAL.placement.geo][window.MALCreative].replace('%time%', new Date().getTime() );
					img.src = src;
				}

				YAHOOFPAD.track(label);
				window.open(url);
			},

			onBandwidth: {
				unique: true,
				handler: function (o) {

					MAL.log('BANDWIDTH',o.bandwidth);
					o.bandwidth += 400;

					this.bandwidth = Math.floor(o.bandwidth);

					MAL.log('Actual bandwidth:',this.bandwidth);

					if (MAL.Environment.hasLocalStorage) {

						if (localStorage.getItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode)) {
							this.cached = true;
							this.bandwidth = parseInt(localStorage.getItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode),0);
							MAL.Util.log('RMV: Bandwidth Cached',this.bandwidth);
							YAHOOFPAD.track('billboard_view_billboard_bandwidthcached' + this.getBandwidthString());
						} else {
							try {
								localStorage.setItem('MALBWTRK' + window.MALCreative + '-' + MAL.placement.siteCode,this.bandwidth);
								MAL.Util.log('RMV: BandWidth',this.bandwidth);
								YAHOOFPAD.track('billboard_view_billboard_bandwidth' + this.getBandwidthString());
							} catch (e) {
								return false;
							}
						}
					}
				}
			}
		}
	}));
};

var MALRMV = MALRMVYahoo;