MAL.define('services.Keyline', MAL.Object.extend({

    /**
     * For rendering the keyline.
     *
     * @type HTMLCanvasElement
     * @private
     */
    _canvas: null,

    /**
     * CanvasContext2D
     */
    ctx: null,

    /**
     * For displaying the rendered keyline
     *
     * @type HTMLImageElement
     */
    element: null,

    /**
     * Color of the keyline
     *
     * @type string
     */
    color: '',

    /**
     * Width of the keyline,
     */
    width: -1,


    /**
     * Height of the keyline,
     */
    height: -1,

    /**
     *
     * @param $config
     * @returns {*|Error}
     */
    initialize: function ($config) {
        $config = $config || {};
        this._super();

        this.color = $config.color || '#000000';
        this.width = $config.width || MAL.error('keyline requires a width');
        this.height = $config.height || MAL.error('keyline requires a height');

        this._canvas = document.createElement('canvas');
        this._canvas.width = this.width;
        this._canvas.height = this.height;

        this.element = $config.drawImg ? document.createElement('img') : this._canvas;

        if (!this._canvas.getContext && !this.element.getContext('2d')) {
            return MAL.error('keyline only supports canvas');
        }

        this.ctx = this._canvas.getContext('2d');

        if( $config.drawImg ) {
            this.drawImg();
            this.drawImg();
            this.drawImg();
        } else {
            this.drawCanvas();
            this.drawCanvas();
            this.drawCanvas();
        }
 

        if ($config.container) {
            $config.container.appendChild(this.element);
        }
    },

    /**
     * Draws keyline and puts the result in a image.
     */
    drawImg: function () {
        this.ctx.strokeStyle = this.color;
        this.ctx.rect(0, 0, this.width, this.height);
        this.ctx.stroke();

        // set rendered data from canvas to image src. this fixes ie10,11 subpixel problems
        this.element.src = this._canvas.toDataURL('image/png');
    },

    drawCanvas: function() {
        this.ctx.strokeStyle = this.color;
        this.ctx.moveTo(0,0);
        this.ctx.lineTo(this.width,0);
        this.ctx.lineTo(this.width,this.height);
        this.ctx.lineTo(0,this.height);
        this.ctx.lineTo(0,0);
        this.ctx.stroke();
    }

}));