MAL.define('services.ScrollRange', MAL.Object.extend({

	initialize: function($config){
		this._super();

		var defaultOptions = {
			top: 0.0,
			bottom: 1.0
		};

		$config = MAL.mergeOptions(defaultOptions, $config || {});

		this.top = $config.top;
		this.bottom = $config.bottom;
	},

	map: function(input, min, max) {

		var value = (input < this.top) ? this.top :
					(input > this.bottom) ? this.bottom :
					input;

		return min + ((max - min) * (value - this.top) / (this.bottom - this.top));
	},

	isInRange: function(value) {

		if (value >= this.top && value <= this.bottom && !MAL.Util.isUndefined(this.top) && !MAL.Util.isUndefined(this.bottom)) {
			return true;
		}

		return false;
	},

	disable: function() {
		this.top = undefined;
		this.bottom = undefined;
	}

}));