MAL.define('services.Supertag', MAL.Object.extend({
	initialize: function($config, collapse){
		this._super();
		this.config = $config;
		this.connection = this.config.connection;
		this.$collapse = collapse || this.config.collapse;
		this.setup();
		this.size = null;
		return this;
	},

	setup: function(){

		if(this.$collapse){
			this.collapse();
			return;
		}

		this.breakpoints = this.config.breakpoints || null;

		this.config.placementId = typeof prPlacementId !== 'undefined' ? prPlacementId : 0;

		if(this.breakpoints === null){
			MAL.error('No breakpoints set.');
		}

		/*this.connection.setDebugMode(true);
		if(MAL.Environment.browser === 'msie' && !window.console){
			this.connection.setDebugMode(false);
		}*/

		var sizes = this.sizes = MAL.clone(this.breakpoints);
		sizes.width = [];
		if(this.breakpoints && this.breakpoints.width){
			for (var width in this.breakpoints.width){
				if(width === 'max'){
					sizes.width.push(200000);
				} else{
					sizes.width.push(parseInt(width, 10));
				}
			}
		}
		sizes.height = [];
		if(this.breakpoints && this.breakpoints.height){
			for (var height in this.breakpoints.height){
				if(height === 'max'){
					sizes.height.push(200000);
				} else{
					sizes.height.push(parseInt(height, 10));
				}
			}
		}

		this.connection.updateAdSize = this.update;
		this.connection.updatePageScroll = this.updatePageScroll;

		this.connectionInstance = this.connection.createConnection(this.config.container, sizes, this.config.placementId, this.config.nested);


		this.waitForPageInfo(10);
	},

	waitForPageInfo: function(attempts) {

		var self = this;
		var pageInfo = this.connection.getPubPageInfo();

		if (attempts > 0) {
			attempts--;
			setTimeout(function() {
				if (MAL.Util.isObject(pageInfo) && !MAL.Util.isUndefined(pageInfo.window)) {
					
					self.dispatchEvent('page-ready', {
						windowSize: pageInfo.window,
						pageScroll: pageInfo.scroll,
						bannerRect: pageInfo.iframe
					});
				} else {
					self.waitForPageInfo(attempts);
				}
			}, 50);
		} else {
			self.dispatchEvent('page-failed', {});
		}
	},

	update: function(sizeIndex, type){
		console.log(arguments);

		var size = this.sizes[type][sizeIndex];

		if(size === 200000){
			size = 'max';
		}

		if(this.breakpoints[type] && this.breakpoints[type][size]){
			this.connection.sendMessageToPub(this.breakpoints[type][size]);
			this.dispatchEvent('size-update', {change: type, current:size, prior: this.size});
			this.size = size;
		}
	},

	addPageListener: function(target, eventName, callback){
		this.connection.addPageListener(target, eventName, callback);
	},

	setDebug: function(debug){
		// this.connection.setDebugMode(debug);
	},

	message: function(message){
		this.connection.sendMessageToPub(message);
	},

	updatePageScroll: function(position){
		MAL.log('updated scroll position: '+position);
	},

	setAdSlotTarget: function(slot){
		this.connection.sendMessageToPub({setAdSlotTarget: slot});
	},

	addCustomStyles: function(message){
		this.connection.sendMessageToPub({addDirectStyles: message});
	},

	addImportantStyles: function(message){
		this.connection.sendMessageToPub({overwriteImportantStyles: message});
	},

	collapse: function(){
		this.connection.closeAd();
	},

	hide: function(){
		this.connection.sendMessageToPub({hide: null});
	},

	reveal: function(){
		this.connection.sendMessageToPub({reveal: null});
	},

	page: function(){
		return this.connection.getPubPageInfo();
	}
}));