MAL.define('views.RichMedia.Main', MAL.View.extend({

    initialize: function(){
        this.html = this.renderHtml();
        this._super();
    },

    styles: function () {
        var styles = {
                'view': {
                    'position': 'relative',
                    'z-index': 0,
                    'width': 1300,
                    'height': 265,
                    'margin': 'auto',
                    'backface-visibility' : 'hidden',
                    'cursor': 'auto',
                    'overflow': 'hidden'
                },

                '#clickthrough': {
                    'z-index': 999999,
                    'display': 'block',
                    'position': 'absolute',
                    'width': '100%',
                    'height': '100%',
                    'top': 0,
                    'left': 0,
                    'cursor': 'pointer'
                },

                '#frames':{
                    'position': 'absolute',
                    'overflow': 'hidden',
                    'width': '100%',
                    'height': '100%',
                    'top': 0,
                    'left': 0,
                    'bottom': 0,
                    'right': 0,
                    'transform-origin': '0 0 0',
                    '-webkit-transform-origin': '0 0 0'
                },

                '#frame': {
                    'position': 'absolute',
                    'overflow': 'hidden',
                    'display': 'inline-block',
                    'width': '1300px',
                    'height': 'auto',
                    'top': 0,
                    'left': 0,
                    'bottom': 0,
                    'right': 0,
                    'margin': 'auto',
                    'background-repeat': 'no-repeat',
                    'background': 'url(sprites-' + MAL.placement.geo + '.jpg) no-repeat'
                },

                '#supers':{
                    'position': 'absolute',
                    'overflow': 'hidden',
                    'width': '100%',
                    'height': '265px',
                    'top': 0,
                    'left': 0,
                    'bottom': 0,
                    'right': 0,
                    'transform-origin': '0 0 0' ,
                    '-webkit-transform-origin': '0 0 0'
                },

                '.super':{
                    'position': 'absolute',
                    'overflow': 'hidden',
                    'width': '100%',
                    'height': '265px',
                    'background-repeat': 'no-repeat',
                    'opacity': 0,
                },

                '#super-1':{
                    'background-image': 'url(super_1-1300-' + MAL.placement.geo + '.svg)'
                },

                '#super-2':{
                    'background-image': 'url(super_2-1300-' + MAL.placement.geo + '.svg)'
                },


                '#loader': {
                    'position': 'absolute',
                    'width': '100%',
                    'height': '100%',
                    'top': 0,
                    'left': 0,
                    'background-color': '#ffffff',
                    'opacity': 0.999
                },

                '#logo':{
                    'width': 35,
                    'height': 43,
                    'position': 'absolute',
                    'top': '50%',
                    'left': '50%',
                    //'display': 'none',
                    'margin-left': -17.5,
                    'margin-top' : -40,
                    'z-index': 100,
                    'background': 'url(data:image/gif;base64,R0lGODlhIwArAMQAALa2ttjY2MXFxfr6+vX19d3d3efn57u7u87OzsDAwPDw8OLi4uvr69PT08nJyf///7GxsQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAAAAAAALAAAAAAjACsAAAXx4COOZGk+RHNAzOm+ZQDNLGybg0DPw+2Ljh3k8PMVhJBA8QYQAnrL1wJpiMIaQqX1paMttjAdAEEAEwoNAaJQxhnSAkGgCmN0hQm2yIBoIgEBUCVYSHh+hTQHCiUIiI6PEACLIjKQlkhEDwqXnDQJk3edkAlQBKKXTyOVp49fI6GsfyWxjwiztIhaI7iILSS8ha67wFm3xDQCJYfHEG0isMS2qsw7vg8G1DSSw9mRBUDdyNfhM5kr4VpH3akPA+fUug9T1Oyv1MIjBMu4Di7YwAcEmVBHaxsMgjvGBFiYoJBBGwwaznBAhwSBABIhkDERAgA7)'
                },

                '#spinner': {
                    'position': 'absolute',
                    'width': 16,
                    'height':16,
                    'top': '50%',
                    //'display': 'none',
                    'left': '50%',
                    'margin-left': -8,
                    'margin-top': 20,
                    'background': 'url(data:image/gif;base64,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)',
                    'z-index': 100
                },

                '#overlay':{
                    'position': 'absolute',
                    'overflow': 'hidden',
                    'width': '100%',
                    'height': '100%',
                    'cursor': 'pointer',
                    'background-color': '#ff0000',
                    'opacity': 0
                }
            };

            return styles; 
    },

    renderHtml : function(){

        var clickthrough = '<div id="clickthrough"></div>';

        var frames =    '<div id="frames">'+
                            '<div id="frame" ></div>' +
                        '</div>';

        var supers =    '<div id="supers">' + 
                            '<div id="super-1" class="super"></div>' +
                            '<div id="super-2" class="super"></div>' +
                        '</div>';

        var loader =    '<div id="loader">' + 
                            '<div id="logo"></div>' +
                            '<div id="spinner"></div>' +
                        '</div>';

        var overlay =   '<div id="overlay"></div>'

        return clickthrough + frames + supers + loader + overlay;
    },

    html: ''

}));